/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waf.security.authentication.debug;

import com.crawler.waf.security.authens.UserAuthentication;
import com.crawler.waf.security.authens.UserCenterUserDetails;
import com.crawler.waf.security.authentication.WafAuthenticationException;
import com.crawler.waf.security.authentication.debug.PreAuthenticatedDebugTokenAuthentication;
import com.crawler.waf.security.services.UserDetailsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
@Order(value=30)
public class DebugTokenAuthenticationProvider
implements AuthenticationProvider {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private UserDetailsService ucUserDetailsService;

    @Autowired
    public void setUcUserDetailsService(UserDetailsService ucUserDetailsService) {
        this.ucUserDetailsService = ucUserDetailsService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Assert.notNull((Object)authentication, (String)"authentication");
        PreAuthenticatedDebugTokenAuthentication wafAuthertication = (PreAuthenticatedDebugTokenAuthentication)authentication;
        UserCenterUserDetails userDetials = null;
        try {
            userDetials = this.ucUserDetailsService.loadUserDetailsByUserId(wafAuthertication.getUserId());
        }
        catch (RuntimeException ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw new WafAuthenticationException("\u6388\u6743\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38 " + ex.getMessage(), ex);
        }
        UserAuthentication authertication = new UserAuthentication(userDetials.getAuthorities());
        userDetials.getUserInfo().setUserType("Debug");
        authertication.setDetails(userDetials);
        authertication.setAuthenticated(true);
        return authertication;
    }

    public boolean supports(Class<?> authentication) {
        return authentication == PreAuthenticatedDebugTokenAuthentication.class;
    }
}

