/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waf.security.authentication.debug;

import com.crawler.waf.config.WafProperties;
import com.crawler.waf.security.authentication.PreAuthenticatedAuthenticationExtractor;
import com.crawler.waf.security.authentication.debug.PreAuthenticatedDebugTokenAuthentication;
import javax.security.sasl.AuthenticationException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
@Order(value=30)
public class PreAuthenticatedDebugTokenAuthenticationExtractor
implements PreAuthenticatedAuthenticationExtractor {
    @Override
    public String getPrefix() {
        return "DEBUG";
    }

    @Override
    public Authentication extractAuthentication(String authenticationValue, HttpServletRequest request) throws AuthenticationException {
        boolean supportDebug = WafProperties.getPropertyForBoolean("token.support_debug", "false");
        String sandboxUrl = WafProperties.getProperty("token.sandbox_url", "http://api.xmappservice.com");
        String origin = request.getHeader("origin");
        if (!supportDebug && !sandboxUrl.equals(origin)) {
            throw new InsufficientAuthenticationException("\u4e0d\u652f\u6301DEBUG\u6a21\u5f0f");
        }
        String[] tokenSlips = authenticationValue.split("=");
        if (tokenSlips.length < 2 || !tokenSlips[0].trim().equals("userId")) {
            throw new InsufficientAuthenticationException("Authorization \u5934\u4fe1\u606f\u503c\u9519\u8bef ");
        }
        String userId = tokenSlips[1].trim();
        return new PreAuthenticatedDebugTokenAuthentication(userId);
    }
}

