/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waf.security.authentication.mac;

import com.crawler.waf.security.authens.OauthAccessToken;
import com.crawler.waf.security.authens.UserAuthentication;
import com.crawler.waf.security.authens.UserCenterUserDetails;
import com.crawler.waf.security.authentication.WafAuthenticationException;
import com.crawler.waf.security.authentication.mac.PreAuthenticatedMacTokenAuthentication;
import com.crawler.waf.security.services.TokenService;
import com.crawler.waf.security.services.UserDetailsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
@Order(value=20)
public class MacTokenAuthenticationProvider
implements AuthenticationProvider {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private UserDetailsService ucUserDetailsService;
    private TokenService ucMacTokenService;

    @Autowired
    public void setUcUserDetailsService(UserDetailsService ucUserDetailsService) {
        this.ucUserDetailsService = ucUserDetailsService;
    }

    @Autowired
    public void setTokenService(@Qualifier(value="mac_token_service") TokenService ucMacTokenService) {
        this.ucMacTokenService = ucMacTokenService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Assert.notNull((Object)authentication, (String)"authentication");
        PreAuthenticatedMacTokenAuthentication wafAuthertication = (PreAuthenticatedMacTokenAuthentication)authentication;
        OauthAccessToken token = this.ucMacTokenService.verifyToken((Authentication)wafAuthertication);
        UserCenterUserDetails userDetials = null;
        UserAuthentication authertication = null;
        if (token != null) {
            try {
                userDetials = this.ucUserDetailsService.loadUserDetailsByUserId(token.getUserId());
            }
            catch (RuntimeException ex) {
                this.logger.error(ex.getMessage(), (Throwable)ex);
                throw new WafAuthenticationException("\u6388\u6743\u8fc7\u7a0b\u53d1\u751f\u5f02\u5e38 " + ex.getMessage(), ex);
            }
            userDetials.getUserInfo().setUserType("Mac");
            authertication = new UserAuthentication(userDetials.getAuthorities());
            authertication.setAuthenticated(true);
            authertication.setDetails(userDetials);
            authertication.setToken(token);
        }
        return authertication;
    }

    public boolean supports(Class<?> authentication) {
        return authentication == PreAuthenticatedMacTokenAuthentication.class;
    }
}

