/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waf.security.services.impl;

import com.crawler.waf.config.WafProperties;
import com.crawler.waf.security.authens.OauthAccessToken;
import com.crawler.waf.security.authentication.bearer.PreAuthenticatedBearerTokenAuthentication;
import com.crawler.waf.security.authentication.mac.PreAuthenticatedMacTokenAuthentication;
import com.crawler.waf.security.services.impl.UserCenterBearerTokenService;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;

public class UserCenterBearerTokenCacheService
extends UserCenterBearerTokenService {
    private static LoadingCache<String, OauthAccessToken> bearerTokenCache;
    public static final String BEARER_TOKEN_CACHE_EXPIRE = "bearerToken.cache.expire";
    public static final String BEARER_TOKEN_CACHE_MAX_SIZE = "bearerToken.cache.maxSize";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMacCache() {
        if (bearerTokenCache == null) {
            UserCenterBearerTokenCacheService userCenterBearerTokenCacheService = this;
            synchronized (userCenterBearerTokenCacheService) {
                if (bearerTokenCache == null) {
                    bearerTokenCache = CacheBuilder.newBuilder().maximumSize((long)WafProperties.getPropertyForInteger(BEARER_TOKEN_CACHE_MAX_SIZE, "1000")).expireAfterWrite((long)WafProperties.getPropertyForInteger(BEARER_TOKEN_CACHE_EXPIRE, "1440"), TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, OauthAccessToken>(){

                        public OauthAccessToken load(String key) throws Exception {
                            return UserCenterBearerTokenCacheService.this.invoke(key);
                        }
                    });
                }
            }
        }
    }

    private OauthAccessToken invoke(String bearerToken) {
        return super.verifyToken((Authentication)new PreAuthenticatedBearerTokenAuthentication(bearerToken));
    }

    @Override
    public OauthAccessToken verifyToken(Authentication preAuthenticatedAuthentication) {
        Assert.notNull((Object)preAuthenticatedAuthentication, (String)"preAuthenticatedAuthentication");
        PreAuthenticatedBearerTokenAuthentication bearerTokenAuthentication = (PreAuthenticatedBearerTokenAuthentication)preAuthenticatedAuthentication;
        this.initMacCache();
        OauthAccessToken ucCheckToken = null;
        try {
            ucCheckToken = (OauthAccessToken)bearerTokenCache.get((Object)bearerTokenAuthentication.getBearerToken());
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        Assert.notNull((Object)ucCheckToken, (String)"ucCheckToken");
        if (ucCheckToken.getBearerToken().equalsIgnoreCase(bearerTokenAuthentication.getBearerToken())) {
            return ucCheckToken;
        }
        return null;
    }

    @Override
    public void removeCache(String accessToken) {
        PreAuthenticatedMacTokenAuthentication authentication = new PreAuthenticatedMacTokenAuthentication(accessToken);
        if (bearerTokenCache != null) {
            bearerTokenCache.invalidate((Object)authentication);
        }
    }
}

