/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waf.security.services.impl;

import com.crawler.client.http.RestHttpClient;
import com.crawler.client.util.UrlUtil;
import com.crawler.uc.config.UcConstant;
import com.crawler.uc.utils.UcSimulator;
import com.crawler.waf.config.WafProperties;
import com.crawler.waf.security.authens.OauthAccessToken;
import com.crawler.waf.security.authentication.bearer.PreAuthenticatedBearerTokenAuthentication;
import com.crawler.waf.security.services.TokenService;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;

public class UserCenterBearerTokenService
implements TokenService {
    public static final String UC_BEARER_TOKEN = "uc.bearerToken";
    private RestHttpClient apiClient = new RestHttpClient();

    String getBearerTokenValidUrl() {
        return UrlUtil.combine(WafProperties.getProperty("uc.uri"), WafProperties.getProperty(UC_BEARER_TOKEN, "bearer_token/verify/{bearer_token}"));
    }

    @Override
    public OauthAccessToken verifyToken(Authentication preAuthenticatedAuthentication) {
        Assert.notNull((Object)preAuthenticatedAuthentication, (String)"preAuthenticatedAuthentication");
        PreAuthenticatedBearerTokenAuthentication bearerTokenAuthentication = (PreAuthenticatedBearerTokenAuthentication)preAuthenticatedAuthentication;
        if (UcConstant.UC_ENABLE) {
            String bearerTokenValidUrl = this.getBearerTokenValidUrl();
            return this.apiClient.postForObject(bearerTokenValidUrl, (Object)preAuthenticatedAuthentication, OauthAccessToken.class, bearerTokenAuthentication.getBearerToken());
        }
        return UcSimulator.get("Bearer", bearerTokenAuthentication.getBearerToken());
    }

    @Override
    public void removeCache(String accessToken) {
    }
}

