/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waf.security.services.impl;

import com.crawler.uc.config.UcConstant;
import com.crawler.uc.utils.UcRedisManager;
import com.crawler.waf.config.WafProperties;
import com.crawler.waf.exception.SimpleException;
import com.crawler.waf.security.authens.OauthAccessToken;
import com.crawler.waf.security.authentication.WafAuthenticationException;
import com.crawler.waf.security.authentication.mac.PreAuthenticatedMacTokenAuthentication;
import com.crawler.waf.security.services.impl.UserCenterMacTokenService;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.security.crypto.codec.Hex;
import org.springframework.util.Assert;

public class UserCenterMacTokenCacheService
extends UserCenterMacTokenService {
    private static LoadingCache<PreAuthenticatedMacTokenAuthentication, OauthAccessToken> macTokenCache;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String MAC_TOKEN_CACHE_EXPIRE = "macToken.cache.expire";
    public static final String MAC_TOKEN_CACHE_MAX_SIZE = "macToken.cache.maxSize";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMacCache() {
        if (macTokenCache == null) {
            UserCenterMacTokenCacheService userCenterMacTokenCacheService = this;
            synchronized (userCenterMacTokenCacheService) {
                if (macTokenCache == null) {
                    macTokenCache = CacheBuilder.newBuilder().maximumSize((long)WafProperties.getPropertyForInteger(MAC_TOKEN_CACHE_MAX_SIZE, "10000")).expireAfterWrite((long)WafProperties.getPropertyForInteger(MAC_TOKEN_CACHE_EXPIRE, "120"), TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<PreAuthenticatedMacTokenAuthentication, OauthAccessToken>(){

                        public OauthAccessToken load(PreAuthenticatedMacTokenAuthentication key) throws Exception {
                            return UserCenterMacTokenCacheService.this.invoke((Authentication)key);
                        }
                    });
                }
            }
        }
    }

    private OauthAccessToken invoke(Authentication preAuthenticatedAuthentication) {
        return super.verifyToken(preAuthenticatedAuthentication);
    }

    @Override
    public OauthAccessToken verifyToken(Authentication preAuthenticatedAuthentication) {
        Assert.notNull((Object)preAuthenticatedAuthentication, (String)"preAuthenticatedAuthentication");
        PreAuthenticatedMacTokenAuthentication authentication = (PreAuthenticatedMacTokenAuthentication)preAuthenticatedAuthentication;
        this.initMacCache();
        OauthAccessToken ucCheckToken = null;
        try {
            ucCheckToken = (OauthAccessToken)macTokenCache.get((Object)authentication);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        Assert.notNull((Object)ucCheckToken, (String)"ucCheckToken");
        return this.checkMac(ucCheckToken, authentication);
    }

    @Override
    public void removeCache(String accessToken) {
        PreAuthenticatedMacTokenAuthentication authentication = new PreAuthenticatedMacTokenAuthentication(accessToken);
        if (macTokenCache != null) {
            macTokenCache.invalidate((Object)authentication);
        }
    }

    public OauthAccessToken checkMac(OauthAccessToken ucCheckToken, PreAuthenticatedMacTokenAuthentication authRequest) {
        String[] arr;
        Assert.notNull((Object)ucCheckToken, (String)"ucCheckToken");
        Assert.notNull((Object)((Object)authRequest), (String)"authRequest");
        String host = authRequest.getHost();
        if (UcConstant.HOST_REPLACE != null && (arr = UcConstant.HOST_REPLACE.split("=>")).length == 2 && host.equals(arr[0].trim())) {
            host = arr[1].trim();
        }
        String nonce = authRequest.getNonce();
        String key = "uc:token:nonce:" + nonce;
        if (UcRedisManager.exists(key)) {
            throw new SimpleException("\u5f53\u524dnonce\u5df2\u4f7f\u7528");
        }
        long timestamp = Long.parseLong(nonce.split(":")[0]);
        if (Math.abs(timestamp - System.currentTimeMillis()) > 300000L) {
            throw new SimpleException("\u65f6\u95f4\u6233\u8d85\u8fc7\u6709\u6548\u65f6\u95f4");
        }
        StringBuilder sbRawMac = new StringBuilder();
        sbRawMac.append(authRequest.getNonce());
        sbRawMac.append("\n");
        sbRawMac.append(authRequest.getHttpMethod().toUpperCase());
        sbRawMac.append("\n");
        sbRawMac.append(authRequest.getRequestUri());
        sbRawMac.append("\n");
        sbRawMac.append(host);
        sbRawMac.append("\n");
        String hmac256 = UserCenterMacTokenCacheService.encryptHMac256(sbRawMac.toString(), ucCheckToken.getMacKey());
        String md5 = UserCenterMacTokenCacheService.md5(sbRawMac.toString(), ucCheckToken.getMacKey());
        String mac = authRequest.getMac();
        String algorithm = WafProperties.getProperty("token.algorithm");
        boolean verify = true;
        if ("md5".equalsIgnoreCase(algorithm) && !mac.equalsIgnoreCase(md5)) {
            verify = false;
        } else if ("hmac256".equalsIgnoreCase(algorithm) && !mac.equalsIgnoreCase(hmac256)) {
            verify = false;
        } else if (!mac.equalsIgnoreCase(hmac256) && !mac.equalsIgnoreCase(md5)) {
            verify = false;
        }
        if (!verify) {
            this.logger.error(authRequest.getMac() + ":" + sbRawMac.toString());
            throw new WafAuthenticationException("\u6388\u6743\u6821\u9a8c\u5931\u8d25");
        }
        return ucCheckToken;
    }

    public static String encryptHMac256(String content, String key) {
        Assert.notNull((Object)content, (String)"content");
        Assert.notNull((Object)key, (String)"key");
        SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(), "HmacSHA256");
        Mac mac = null;
        try {
            mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        byte[] digest = mac.doFinal(content.getBytes());
        return new String(Base64.encode((byte[])digest));
    }

    public static String md5(String content, String key) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            if (key != null && !"".equals(key)) {
                content = content + "{" + key.toString() + "}";
            }
            byte[] digest = messageDigest.digest(content.getBytes("utf-8"));
            return new String(Hex.encode((byte[])digest));
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }
}

