/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waf.security.services.impl;

import com.crawler.client.http.RestHttpClient;
import com.crawler.client.util.UrlUtil;
import com.crawler.uc.config.UcConstant;
import com.crawler.uc.utils.UcSimulator;
import com.crawler.waf.config.WafProperties;
import com.crawler.waf.security.authens.OauthAccessToken;
import com.crawler.waf.security.authentication.mac.PreAuthenticatedMacTokenAuthentication;
import com.crawler.waf.security.services.TokenService;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;

public class UserCenterMacTokenService
implements TokenService {
    public static final String UC_MAC_TOKEN = "uc.macToken";
    private RestHttpClient apiClient = new RestHttpClient();

    String getTokenValidUrl() {
        return UrlUtil.combine(WafProperties.getProperty("uc.uri"), WafProperties.getProperty(UC_MAC_TOKEN, "token/verify/{access_token}"));
    }

    @Override
    public OauthAccessToken verifyToken(Authentication preAuthenticatedAuthentication) {
        Assert.notNull((Object)preAuthenticatedAuthentication, (String)"preAuthenticatedAuthentication");
        PreAuthenticatedMacTokenAuthentication authentication = (PreAuthenticatedMacTokenAuthentication)preAuthenticatedAuthentication;
        if (UcConstant.UC_ENABLE) {
            String tokenValidUrl = this.getTokenValidUrl();
            return this.apiClient.postForObject(tokenValidUrl, (Object)preAuthenticatedAuthentication, OauthAccessToken.class, authentication.getId());
        }
        return UcSimulator.get("MAC", authentication.getId());
    }

    @Override
    public void removeCache(String accessToken) {
    }
}

