/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waf.security.services.impl;

import com.crawler.client.http.SecurityHttpClient;
import com.crawler.client.util.UrlUtil;
import com.crawler.uc.config.UcConstant;
import com.crawler.uc.utils.UcSimulator;
import com.crawler.waf.config.WafProperties;
import com.crawler.waf.security.authens.BaseUserInfo;
import com.crawler.waf.security.authens.UserCenterUserDetails;
import com.crawler.waf.security.authens.UserRole;
import com.crawler.waf.security.services.UserDetailsService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class UserCenterUserDetailsService
implements UserDetailsService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String UC_GET_USER_INFO = "uc.get.userInfo";
    private static final String UC_GET_USER_ROLES = "uc.get.userRoles";
    protected SecurityHttpClient securityApiClient = new SecurityHttpClient();

    String getUserInfoUrl() {
        return UrlUtil.combine(WafProperties.getProperty("uc.uri"), WafProperties.getProperty(UC_GET_USER_INFO, "user/{user_id}"));
    }

    String getUserRolesUrl() {
        return UrlUtil.combine(WafProperties.getProperty("uc.uri"), WafProperties.getProperty(UC_GET_USER_ROLES, "user/{user_id}/roles"));
    }

    @Override
    public List<UserRole> getUserRoleList(String userId) {
        Assert.notNull((Object)userId, (String)"userId");
        if (UcConstant.UC_ENABLE) {
            String userRolesUrl = this.getUserRolesUrl();
            Map resMap = this.securityApiClient.getForObject(userRolesUrl, Map.class, userId);
            if (resMap != null) {
                List lists = (List)resMap.get("items");
                ArrayList<UserRole> roles = new ArrayList<UserRole>();
                for (LinkedHashMap linkedMap : lists) {
                    UserRole role = new UserRole();
                    role.setRoleId(linkedMap.get("role_id").toString());
                    role.setRoleName(linkedMap.get("role_name").toString());
                    try {
                        String dateString = linkedMap.get("update_time").toString();
                        String pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
                        SimpleDateFormat formatDate = new SimpleDateFormat(pattern);
                        role.setUpdateTime(formatDate.parse(dateString));
                    }
                    catch (ParseException e) {
                        throw new RuntimeException("\u89e3\u6790\u65f6\u95f4\u53d1\u751f\u5f02\u5e38 " + linkedMap.get("update_time").toString(), e);
                    }
                    roles.add(role);
                }
                return roles;
            }
            return new ArrayList<UserRole>();
        }
        return UcSimulator.getRoleList(userId);
    }

    @Override
    public BaseUserInfo getUserInfo(String userId) {
        Assert.notNull((Object)userId, (String)"userId");
        if (UcConstant.UC_ENABLE) {
            String userInfoUrl = this.getUserInfoUrl();
            return this.securityApiClient.getForObject(userInfoUrl, BaseUserInfo.class, userId);
        }
        return UcSimulator.getUserInfo(userId);
    }

    @Override
    public UserCenterUserDetails loadUserDetailsByUserId(String userId) {
        BaseUserInfo user = this.getUserInfo(userId);
        this.logger.info("user:" + user + ",userId:" + userId);
        List<UserRole> roleDetailsCollection = this.getUserRoleList(userId);
        UserCenterUserDetails details = new UserCenterUserDetails(user, roleDetailsCollection);
        return details;
    }
}

