/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waf.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomDateSerializer
extends JsonSerializer<Date> {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public void serialize(Date value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
        gen.writeString(this.toString(value));
    }

    private String toString(Date date) {
        Date now = new Date();
        long diff = (long)Math.floor((now.getTime() - date.getTime()) / 60000L);
        if (diff < 1L) {
            return "\u521a\u521a";
        }
        if (diff < 60L) {
            return diff + "\u5206\u949f\u524d";
        }
        if (diff < 1440L) {
            int hours = (int)Math.floor(diff / 60L);
            return hours + "\u5c0f\u65f6\u524d";
        }
        if (this.isSameYear(date, now)) {
            return this.toString(date, "MM-dd HH:mm");
        }
        return this.toString(date, "yy-MM-dd HH:mm");
    }

    private String toString(Date date, String format) {
        String result = "";
        if (date != null) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(format);
                result = sdf.format(date);
            }
            catch (Exception ex) {
                this.logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return result;
    }

    private boolean isSameYear(Date src, Date dest) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(src);
        int srcYear = calendar.get(1);
        calendar.setTime(dest);
        int destYear = calendar.get(1);
        return srcYear == destYear;
    }
}

