/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waf.serializer;

import com.crawler.waf.config.WafProperties;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;

public class HtmlSerializer
extends JsonSerializer<String> {
    private static final String TITLE = WafProperties.getProperty("app.name", "\u53a6\u95e8\u722c\u866b\u79d1\u6280\u7f51\u7edc\u516c\u53f8");

    public void serialize(String value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
        if (value.indexOf("<body>") > -1) {
            value = value.replaceAll("[\\s\\S]*<body[^>]*>([\\s\\S]+)</body>[\\s\\S]*", "$1");
        }
        value = value.replaceAll("<img[^>]+src=\"(.*?)(\\?.*?)*\"[^>]*?>", "<img style=\"width:100%;\" src=\"$1?imageView2/2/w/0/h/0/q/80\" />");
        String content = "<html><head><meta charset=\"utf-8\" /><meta name=\"viewport\" content=\"width=device-width,minimum-scale=1.0,maximum-scale=1.0,user-scalable=no\"/><title>" + TITLE + "</title></head><body>" + value + "</body></html>";
        gen.writeString(content);
    }
}

