/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waf.serializer;

import com.crawler.waf.config.WafProperties;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ThumbViewSerializer
extends JsonSerializer<Object> {
    private static final Integer THUMB_WIDTH = WafProperties.getPropertyForInteger("image.thumbwidth", "300");

    public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
        if (value != null) {
            if (value instanceof String) {
                String url = (String)value;
                url = url.split("\\?")[0] + "?imageView2/2/w/" + THUMB_WIDTH + "/h/0/q/80";
                value = url;
            } else if (value instanceof List) {
                ArrayList<String> list = new ArrayList<String>();
                List items = (List)value;
                for (String url : items) {
                    url = url.split("\\?")[0] + "?imageView2/2/w/" + THUMB_WIDTH + "/h/0/q/80";
                    list.add(url);
                }
                value = list;
            }
        }
        gen.writeObject(value);
    }
}

