/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waf.support;

import com.crawler.waf.exceptions.extendExceptions.WafSimpleException;
import com.crawler.waf.exceptions.handlers.ErrorMessageQueueHandler;
import com.crawler.waf.security.authens.BaseUserInfo;
import com.crawler.waf.security.authens.OauthAccessToken;
import com.crawler.waf.security.authens.UserCenterUserDetails;
import com.crawler.waf.security.authens.UserRole;
import java.util.List;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public final class WafContext {
    public static UserCenterUserDetails getCurrentDetails() {
        UserCenterUserDetails details = (UserCenterUserDetails)SecurityContextHolder.getContext().getAuthentication().getDetails();
        return details;
    }

    public static BaseUserInfo getCurrertUserInfo() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            return null;
        }
        Object principal = authentication.getPrincipal();
        if (principal instanceof BaseUserInfo) {
            BaseUserInfo userInfo = (BaseUserInfo)principal;
            return userInfo;
        }
        return null;
    }

    public static OauthAccessToken getCurrentToken() {
        try {
            return (OauthAccessToken)SecurityContextHolder.getContext().getAuthentication().getCredentials();
        }
        catch (ClassCastException ex) {
            System.out.println(SecurityContextHolder.getContext().getAuthentication().getCredentials());
            throw new WafSimpleException("\u83b7\u53d6\u6388\u6743\u4fe1\u606f\u5931\u8d25");
        }
    }

    public static List<UserRole> getCurrentUserRoles() {
        List roles = (List)SecurityContextHolder.getContext().getAuthentication().getAuthorities();
        return roles;
    }

    public static void setCapacity(int capacity) {
        ErrorMessageQueueHandler.setCapacity(capacity);
    }
}

