/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waf.testconfig;

import com.crawler.waf.security.authens.UserAuthentication;
import com.crawler.waf.security.authens.UserCenterUserDetails;
import com.crawler.waf.security.authentication.WafAuthenticationException;
import com.crawler.waf.security.services.impl.UserCenterUserDetailsService;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@RunWith(value=SpringJUnit4ClassRunner.class)
@WebAppConfiguration
public class BaseSpringJunit4Config {
    protected MockMvc mockMvc;
    @Autowired
    private WebApplicationContext webApplicationContext;
    protected String userId;

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Before
    public void setUp() {
        this.mockMvc = MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.webApplicationContext).build();
        UserAuthentication authentication = this.getPrincipal(this.getUserId());
        SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
    }

    protected UserAuthentication getPrincipal(String userId) {
        UserCenterUserDetailsService userCenterUserDetailsService = new UserCenterUserDetailsService();
        UserAuthentication authentication = new UserAuthentication(null);
        try {
            UserCenterUserDetails userCenterUserDetails = userCenterUserDetailsService.loadUserDetailsByUserId(userId);
            authentication.setDetails(userCenterUserDetails);
        }
        catch (RuntimeException ex) {
            throw new WafAuthenticationException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u53d1\u751f\u5f02\u5e38 " + ex.getMessage(), ex);
        }
        return authentication;
    }
}

