package com.crawler.client.auth;

import java.util.Date;

import org.springframework.web.client.RestClientException;

import com.crawler.client.entity.BearerToken;
import com.crawler.client.http.RestHttpClient;
import com.crawler.client.util.UrlUtil;
import com.crawler.uc.utils.UcSimulator;
import com.crawler.waf.config.UcConstant;
import com.crawler.waf.config.WafProperties;
import com.crawler.waf.security.authens.OauthAccessToken;

/**
 * 服务器端bearer_token认证，用户名和密码登陆uc实现

 */
public class BearerTokenServiceImpl implements BearerTokenService {
    public static final String UC_API_REFRESH_TOKEN = "uc.api.refresh_token";
    public static final String UC_API_POST_BEARER_TOKEN = "uc.api.post_bearer_token";
    public static final String CLIENT_BEARER_TOKEN_ACCOUNT_USERNAME = "client.bearerToken.account.username";
    public static final String CLIENT_BEARER_TOKEN_ACCOUNT_PASSWORD = "client.bearerToken.account.password";
    public static final String CLIENT_BEARER_TOKEN_ACCOUNT_APPID = "app.id";

    private static final String UC_API_REFRESH_TOKEN_VALUE = "bearer_token/refresh";
    private static final String UC_API_POST_BEARER_TOKEN_VALUE = "bearer_token";
    private static final String CLIENT_BEARER_TOKEN_ACCOUNT_USERNAME_VALUE = "bearer";
    private static final String CLIENT_BEARER_TOKEN_ACCOUNT_PASSWORD_VALUE = "7d1ee5f6f44e25ec9056db37eeac517c";

    public RestHttpClient getHttpClient() {
        return httpClient;
    }

    public void setHttpClient(RestHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    private RestHttpClient httpClient = new RestHttpClient();

    @Override
    public BearerToken getBearerToken() throws RestClientException {
    	 BearerToken bearerToken = null;
         if(UcConstant.UC_ENABLE){
 	        String uri = getPostBearerTokenUri();
 	        UserCenterAccount ucAccount = getUCAccount();
 	        WafAccessToken accessToken = httpClient.postForObject(uri, ucAccount, WafAccessToken.class);
 	        if (accessToken != null) {
 	            bearerToken = accessToken.toBearerToken();
 	        }
         }
         else{
         	OauthAccessToken oauthAccessToken = UcSimulator.generateBearerToken();
         	bearerToken = new BearerToken(oauthAccessToken.getUserId(), oauthAccessToken.getAccessToken(), oauthAccessToken.getRefreshToken(), oauthAccessToken.getExpiresAt());
         }
         return bearerToken;
    }

    @Override
    public BearerToken refreshBearerToken(BearerToken bearerToken) throws RestClientException {
        BearerToken refreshBearerToken = null;
        String uri = getRefreshTokenUri(bearerToken.getRefreshToken());
        WafAccessToken accessToken = httpClient.getForObject(uri, WafAccessToken.class);
        if (accessToken != null) {
            refreshBearerToken = accessToken.toBearerToken();
        }
        return refreshBearerToken;
    }

    private String getRefreshTokenUri(String refreshToken) {
        return UrlUtil.combine(getProperty(UcConstant.UC_URI),getProperty(UC_API_REFRESH_TOKEN, UC_API_REFRESH_TOKEN_VALUE)) + "/" + refreshToken;
    }

    private String getPostBearerTokenUri() {
        return UrlUtil.combine(getProperty(UcConstant.UC_URI),getProperty(UC_API_POST_BEARER_TOKEN, UC_API_POST_BEARER_TOKEN_VALUE));
    }

    private UserCenterAccount getUCAccount() {
        return new UserCenterAccount(
                getProperty(CLIENT_BEARER_TOKEN_ACCOUNT_USERNAME, CLIENT_BEARER_TOKEN_ACCOUNT_USERNAME_VALUE),
                getProperty(CLIENT_BEARER_TOKEN_ACCOUNT_PASSWORD, CLIENT_BEARER_TOKEN_ACCOUNT_PASSWORD_VALUE),
                getProperty(CLIENT_BEARER_TOKEN_ACCOUNT_APPID)
        );
    }

    private String getProperty(String key) {
        return WafProperties.getProperty(key);
    }

    private String getProperty(String key, String defaultValue) {
        return WafProperties.getProperty(key, defaultValue);
    }

    private static class WafAccessToken {
        private String userId;//应用ID
        private String accessToken;//接收uc提供的bearer_token值
        private Date expiresAt;//过期时间
        private String refreshToken;//过期后用于刷新的token

        public String getUserId() {
            return userId;
        }

        public String getAccessToken() {
            return accessToken;
        }

        public Date getExpiresAt() {
            return expiresAt;
        }

        public String getRefreshToken() {
            return refreshToken;
        }

        public BearerToken toBearerToken() {
            return new BearerToken(getUserId(), getAccessToken(), getRefreshToken(), getExpiresAt());
        }
    }
}



