package com.crawler.client.auth;

import org.springframework.util.Assert;

import java.io.Serializable;

/**
 * 封装UC服务器端认证用户名和密码的对象
 */
class UserCenterAccount implements Serializable {
    private static final long serialVersionUID = 5632331017111432552L;
    private String loginName;
    private String password;
    private String appId;

    public UserCenterAccount(String loginName, String password, String appId) {
        Assert.notNull(loginName, "loginName");
        Assert.notNull(password, "password");
        this.loginName = loginName;
        this.password = password;
        this.appId = appId;
    }

    public String getLoginName() {
        return loginName;
    }

    public String getPassword() {
        return password;
    }

	public String getAppId() {
		return appId;
	}
}
