package com.crawler.client.exception;

import com.fasterxml.jackson.annotation.JsonIgnore;

import java.io.Serializable;

/**
 * 错误信息封装类
 */
public class ErrorMessage implements Serializable {
    private static final long serialVersionUID = -5401402542472113075L;

    /**
     * 编码的Code
     */
    private String code;
    /**
     * 错误信息的message信息。
     */
    private String message;

    /**
     * 详细信息
     */
    private String detail;

    public ErrorMessage() {
    }

    public ErrorMessage(String code) {
        this(code, null, null);
    }

    public ErrorMessage(String code, String message) {
        this(code, message, null);
    }

    public ErrorMessage(String code, String message, String detail) {
        this.message = message;
        this.code = code;
        this.detail = detail;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @JsonIgnore
    public String getDetail() {
        return detail;
    }

    @JsonIgnore
    public void setDetail(String detail) {
        this.detail = detail;
    }


}
