package com.crawler.client.support;

import com.crawler.client.auth.BearerTokenProvider;
import com.crawler.client.auth.BearerTokenServiceImpl;
import com.crawler.client.entity.BearerToken;

/**
 * bearer token处理类
 */
public class ClientContextHolder {

    private static BearerTokenProvider bearerTokenProvider;

    static {
        /**
         * 初始化BearerToken服务类
         */
        bearerTokenProvider = new BearerTokenProvider(new BearerTokenServiceImpl());
    }

    /**
     * 获取bearer_token
     *
     * @throws
     * @return BearerToken
     */
    public static BearerToken getToken() {
        return bearerTokenProvider.getToken();
    }

    /**
     * 判断是否经过授权
     *
     * @throws
     * @return boolean
     */
    public static boolean isAuthorized() {
        return bearerTokenProvider.isAuthorized();
    }

}
