package com.crawler.waf.utils;

import java.util.List;

/**
 * 断言
 * @author rubekid
 *
 * 2017年10月14日 下午9:12:21
 */
public class Assert {

	/**
	 * 非空字符
	 * @param obj
	 * @param message
	 */
	public static void notEmpty(CharSequence obj, String message){
		if(obj == null || "".equals(obj)){
			throw new IllegalStateException(message);
		}
	}
	
	/**
	 * 非空列表
	 * @param list
	 * @param message
	 */
	public static void notEmpty(List<?> list, String message){
		if(list == null || list.size() == 0){
			throw new IllegalStateException(message);
		}
	}
	
	/**
	 * 非 null
	 * @param obj
	 * @param message
	 */
	public static void notNull(Object obj, String message){
		if(obj == null){
			throw new IllegalStateException(message);
		}
	}
}
