package com.crawler.waf.utils;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import org.apache.commons.codec.binary.Hex;

/**
 * 加密
 * @author rubekid
 *
 * 2017年7月26日 下午11:37:23
 */
public class Encrypt {

	/**
	 * Md5 加密
	 * 
	 * @param message
	 * @param salt
	 * @return
	 */
	public static String md5(String message, Object salt) {
		
		try{
			MessageDigest messageDigest = MessageDigest.getInstance("MD5");
			if (salt != null && !"".equals(salt)) {
				message =  message + "{" + salt.toString() + "}";
			}
			byte[] digest = messageDigest.digest(message.getBytes("utf-8"));
			return Hex.encodeHexString(digest);
		}
		catch(NoSuchAlgorithmException | UnsupportedEncodingException ex){}
		
		return null;
	}

	/**
	 * 16位MD5
	 * 
	 * @param password
	 * @return
	 */
	public static String shortMd5(String password) {
		String md5 = md5(password, "");
		return md5.substring(8, 24);
	}

	/**
	 * 传入文本内容，返回 SHA-256 串
	 * 
	 * @param strText
	 * @return
	 */
	public static String SHA256(final String strText) {
		return SHA(strText, "SHA-256");
	}

	/**
	 * 传入文本内容，返回 SHA-512 串
	 * 
	 * @param strText
	 * @return
	 */
	public static String SHA512(final String strText) {
		return SHA(strText, "SHA-512");
	}

	/**
	 * 字符串 SHA 加密
	 * 
	 * @param strSourceText
	 * @return
	 */
	private static String SHA(final String strText, final String strType) {
		// 返回值
		String strResult = null;

		// 是否是有效字符串
		if (strText != null && strText.length() > 0) {
			try {
				// SHA 加密开始
				// 创建加密对象 并传入加密类型
				MessageDigest messageDigest = MessageDigest.getInstance(strType);
				// 传入要加密的字符串
				messageDigest.update(strText.getBytes());
				// 得到 byte 类型结果
				byte byteBuffer[] = messageDigest.digest();

				// 将 byte 转换为 string
				StringBuffer strHexString = new StringBuffer();
				// 遍历byte buffer
				for (int i = 0; i < byteBuffer.length; i++) {
					String hex = Integer.toHexString(0xff & byteBuffer[i]);
					if (hex.length() == 1) {
						strHexString.append('0');
					}
					strHexString.append(hex);
				}
				// 得到返回結果
				strResult = strHexString.toString();
			} catch (NoSuchAlgorithmException e) {
				e.printStackTrace();
			}
		}

		return strResult;
	}
}