/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.client.auth;

import com.crawler.client.auth.BearerTokenService;
import com.crawler.client.entity.BearerToken;
import com.crawler.waf.config.WafProperties;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class BearerTokenProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(BearerTokenProvider.class);
    public static final String CLIENT_MIN_REFRESH_SPAN = "client.minRefreshSpan";
    private static final String CLIENT_MIN_REFRESH_SPAN_VALUE = "300000";
    private BearerToken bearerToken;
    private int minRefreshSpan;
    private BearerTokenService bearerTokenService;

    public BearerTokenProvider(BearerTokenService bearerTokenService) {
        this.bearerTokenService = bearerTokenService;
        this.minRefreshSpan = WafProperties.getPropertyForInteger(CLIENT_MIN_REFRESH_SPAN, CLIENT_MIN_REFRESH_SPAN_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BearerToken getToken() {
        BearerTokenProvider bearerTokenProvider;
        if (this.bearerToken == null) {
            bearerTokenProvider = this;
            synchronized (bearerTokenProvider) {
                this.bearerToken = this.bearerTokenService.getBearerToken();
            }
        }
        Assert.notNull((Object)this.bearerToken, (String)"bearerToken");
        if (this.shouldRefreshToken(this.bearerToken)) {
            bearerTokenProvider = this;
            synchronized (bearerTokenProvider) {
                try {
                    this.bearerToken = this.bearerTokenService.refreshBearerToken(this.bearerToken);
                    System.out.println("\u5237\u65b0BearerToken\u6210\u529f");
                }
                catch (Exception ex) {
                    this.bearerToken = null;
                    LOGGER.error("\u5237\u65b0BearerToken\u5931\u8d25\uff1a" + ex.getMessage());
                }
            }
            if (this.bearerToken == null) {
                bearerTokenProvider = this;
                synchronized (bearerTokenProvider) {
                    System.out.println("\u91cd\u65b0\u83b7\u53d6BearerToken\u6210\u529f");
                    this.bearerToken = this.bearerTokenService.getBearerToken();
                }
            }
        }
        return this.bearerToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setToken(BearerToken token) {
        Assert.notNull((Object)token, (String)"token");
        BearerTokenProvider bearerTokenProvider = this;
        synchronized (bearerTokenProvider) {
            this.bearerToken = token;
        }
    }

    public boolean isAuthorized() {
        return this.bearerToken != null && !this.bearerToken.isExpire();
    }

    protected boolean shouldRefreshToken(BearerToken bearerToken) {
        Assert.notNull((Object)bearerToken, (String)"bearerToken");
        Date now = new Date();
        return bearerToken.getExpiresAt().getTime() - now.getTime() < (long)this.minRefreshSpan;
    }
}

