/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.client.http;

import com.crawler.client.http.WafApiErrorHandler;
import com.crawler.client.http.WafClientHttpRequest;
import com.crawler.client.util.JsonMapper;
import com.crawler.waf.config.WafProperties;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.HeaderElement;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StopWatch;
import org.springframework.web.client.HttpMessageConverterExtractor;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriTemplate;

public class RestHttpClient {
    public static final String CLIENT_CONNECT_TIMEOUT = "client.connectTimeout";
    public static final String CLIENT_SOCKET_TIMEOUT = "client.socketTimeout";
    private static final String CLIENT_CONNECT_TIMEOUT_VALUE = "30000";
    private static final String CLIENT_SOCKET_TIMEOUT_VALUE = "10000";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private RestRestTemplate restTemplate;
    static CloseableHttpClient httpClient;
    static IdleConnectionMonitorThread monitorThread;

    static {
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setBufferSize(8192).setFragmentSizeHint(8192).build();
        SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(Integer.parseInt(CLIENT_SOCKET_TIMEOUT_VALUE)).build();
        ConnectionKeepAliveStrategy keepAliveStrategy = new ConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
                while (it.hasNext()) {
                    HeaderElement he = it.nextElement();
                    String param = he.getName();
                    String value = he.getValue();
                    if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                    try {
                        return Long.parseLong(value) * 1000L;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return 30000L;
            }
        };
        PoolingHttpClientConnectionManager mgr = new PoolingHttpClientConnectionManager();
        mgr.setDefaultSocketConfig(socketConfig);
        mgr.setDefaultConnectionConfig(connectionConfig);
        mgr.setMaxTotal(1000);
        mgr.setDefaultMaxPerRoute(500);
        httpClient = HttpClients.custom().setKeepAliveStrategy(keepAliveStrategy).setConnectionManager((HttpClientConnectionManager)mgr).build();
        monitorThread = new IdleConnectionMonitorThread((HttpClientConnectionManager)mgr);
        monitorThread.setDaemon(true);
        monitorThread.start();
    }

    public RestHttpClient() {
        this(WafProperties.getPropertyForInteger(CLIENT_CONNECT_TIMEOUT, CLIENT_CONNECT_TIMEOUT_VALUE), WafProperties.getPropertyForInteger(CLIENT_SOCKET_TIMEOUT, CLIENT_SOCKET_TIMEOUT_VALUE));
    }

    public RestHttpClient(int connectTimeout, int socketTimeout) {
        if (connectTimeout < 0) {
            throw new IllegalArgumentException("Connect timeout value is illegal, must be >=0");
        }
        if (socketTimeout < 0) {
            throw new IllegalArgumentException("Socket timeout value is illegal, must be >=0");
        }
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        requestFactory.setConnectTimeout(connectTimeout);
        requestFactory.setReadTimeout(socketTimeout);
        this.restTemplate = new RestRestTemplate((ClientHttpRequestFactory)requestFactory);
        MappingJackson2HttpMessageConverter messageConverter = new MappingJackson2HttpMessageConverter();
        messageConverter.setObjectMapper(JsonMapper.getMapper());
        ArrayList<MappingJackson2HttpMessageConverter> mcs = new ArrayList<MappingJackson2HttpMessageConverter>();
        mcs.add(messageConverter);
        this.restTemplate.setMessageConverters(mcs);
        this.restTemplate.setErrorHandler((ResponseErrorHandler)new WafApiErrorHandler());
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public HttpClient getHttpClient() {
        return httpClient;
    }

    protected HttpHeaders mergerHeaders(HttpHeaders headers) {
        return headers;
    }

    public <T> T postForObject(String url, Object requestBody, Class<T> responseType, Object ... uriVariables) {
        HttpEntity<Object> httpEntity = this.getHttpEntity(requestBody);
        return this.executeForObject(url, HttpMethod.POST, httpEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> postForEntity(String url, Object requestBody, Class<T> responseType, Object ... uriVariables) {
        HttpEntity<Object> httpEntity = this.getHttpEntity(requestBody);
        return this.executeForEntity(url, HttpMethod.POST, httpEntity, responseType, uriVariables);
    }

    public void post(String url, Object requestBody, Object ... uriVariables) {
        HttpEntity<Object> httpEntity = this.getHttpEntity(requestBody);
        this.execute(url, HttpMethod.POST, httpEntity, uriVariables);
    }

    public <T> T postForObject(String url, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpEntity<Object> httpEntity = this.getHttpEntity(requestBody);
        return this.executeForObject(url, HttpMethod.POST, httpEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> postForEntity(String url, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpEntity<Object> httpEntity = this.getHttpEntity(requestBody);
        return this.executeForEntity(url, HttpMethod.POST, httpEntity, responseType, uriVariables);
    }

    public void post(String url, Object requestBody, Map<String, ?> uriVariables) {
        HttpEntity<Object> httpEntity = this.getHttpEntity(requestBody);
        this.execute(url, HttpMethod.POST, httpEntity, uriVariables);
    }

    public <T> T getForObject(String url, Class<T> responseType, Object ... uriVariables) {
        HttpEntity<Object> httpEntity = this.getHttpEntity(null);
        return this.executeForObject(url, HttpMethod.GET, httpEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> getForEntity(String url, Class<T> responseType, Object ... uriVariables) {
        HttpEntity<Object> httpEntity = this.getHttpEntity(null);
        return this.executeForEntity(url, HttpMethod.GET, httpEntity, responseType, uriVariables);
    }

    public <T> T getForObject(String url, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpEntity<Object> httpEntity = this.getHttpEntity(null);
        return this.executeForObject(url, HttpMethod.GET, httpEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> getForEntity(String url, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpEntity<Object> httpEntity = this.getHttpEntity(null);
        return this.executeForEntity(url, HttpMethod.GET, httpEntity, responseType, uriVariables);
    }

    public void put(String url, Object requestBody, Object ... uriVariables) {
        HttpEntity<Object> httpEntity = this.getHttpEntity(requestBody);
        this.execute(url, HttpMethod.PUT, httpEntity, uriVariables);
    }

    public <T> T putForObject(String url, Object requestBody, Class<T> responseType, Object ... uriVariables) {
        HttpEntity<Object> httpEntity = this.getHttpEntity(requestBody);
        return this.executeForObject(url, HttpMethod.PUT, httpEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> putForEntity(String url, Object requestBody, Class<T> responseType, Object ... uriVariables) {
        HttpEntity<Object> httpEntity = this.getHttpEntity(requestBody);
        return this.executeForEntity(url, HttpMethod.PUT, httpEntity, responseType, uriVariables);
    }

    public void put(String url, Object requestBody, Map<String, ?> uriVariables) {
        HttpEntity<Object> httpEntity = this.getHttpEntity(requestBody);
        this.execute(url, HttpMethod.PUT, httpEntity, uriVariables);
    }

    public <T> T putForObject(String url, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpEntity<Object> httpEntity = this.getHttpEntity(requestBody);
        return this.executeForObject(url, HttpMethod.PUT, httpEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> putForEntity(String url, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpEntity<Object> httpEntity = this.getHttpEntity(requestBody);
        return this.executeForEntity(url, HttpMethod.PUT, httpEntity, responseType, uriVariables);
    }

    public void delete(String url, Object ... uriVariables) {
        HttpEntity<Object> httpEntity = this.getHttpEntity(null);
        this.execute(url, HttpMethod.DELETE, httpEntity, uriVariables);
    }

    public <T> T deleteForObject(String url, Class<T> responseType, Object ... uriVariables) {
        HttpEntity<Object> httpEntity = this.getHttpEntity(null);
        return this.executeForObject(url, HttpMethod.DELETE, httpEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> deleteForEntity(String url, Class<T> responseType, Object ... uriVariables) {
        HttpEntity<Object> httpEntity = this.getHttpEntity(null);
        return this.executeForEntity(url, HttpMethod.DELETE, httpEntity, responseType, uriVariables);
    }

    public void delete(String url, Map<String, ?> uriVariables) {
        HttpEntity<Object> httpEntity = this.getHttpEntity(null);
        this.execute(url, HttpMethod.DELETE, httpEntity, uriVariables);
    }

    public <T> T deleteForObject(String url, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpEntity<Object> httpEntity = this.getHttpEntity(null);
        return this.executeForObject(url, HttpMethod.DELETE, httpEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> deleteForEntity(String url, Class<T> responseType, Map<String, ?> uriVariables) {
        HttpEntity<Object> httpEntity = this.getHttpEntity(null);
        return this.executeForEntity(url, HttpMethod.DELETE, httpEntity, responseType, uriVariables);
    }

    public <T> T executeForObject(String url, HttpMethod method, HttpEntity<?> requestEntity, Class<T> responseType, Object ... uriVariables) {
        URI uri = new UriTemplate(url).expand(uriVariables);
        HttpEntity<?> mergeRequestEntity = this.merge(requestEntity);
        RequestCallback requestCallback = this.restTemplate.httpEntityCallback(mergeRequestEntity, responseType);
        ResponseExtractor responseExtractor = this.restTemplate.httpMessageConverterExtractor(responseType);
        return this.doExecute(uri, method, requestCallback, responseExtractor);
    }

    public <T> ResponseEntity<T> executeForEntity(String url, HttpMethod method, HttpEntity<?> requestEntity, Class<T> responseType, Object ... uriVariables) {
        URI uri = new UriTemplate(url).expand(uriVariables);
        HttpEntity<?> mergeRequestEntity = this.merge(requestEntity);
        RequestCallback requestCallback = this.restTemplate.httpEntityCallback(mergeRequestEntity, responseType);
        ResponseExtractor responseExtractor = this.restTemplate.responseEntityExtractor(responseType);
        return this.doExecute(uri, method, requestCallback, responseExtractor);
    }

    public void execute(String url, HttpMethod method, HttpEntity<?> requestEntity, Object ... uriVariables) {
        URI uri = new UriTemplate(url).expand(uriVariables);
        HttpEntity<?> mergeRequestEntity = this.merge(requestEntity);
        RequestCallback requestCallback = this.restTemplate.httpEntityCallback(mergeRequestEntity);
        this.doExecute(uri, method, requestCallback, null);
    }

    public <T> T executeForObject(String url, HttpMethod method, HttpEntity<?> requestEntity, Class<T> responseType, Map<String, ?> uriVariables) {
        URI uri = new UriTemplate(url).expand(uriVariables);
        HttpEntity<?> mergeRequestEntity = this.merge(requestEntity);
        RequestCallback requestCallback = this.restTemplate.httpEntityCallback(mergeRequestEntity, responseType);
        ResponseExtractor responseExtractor = this.restTemplate.httpMessageConverterExtractor(responseType);
        return this.doExecute(uri, method, requestCallback, responseExtractor);
    }

    public <T> ResponseEntity<T> executeForEntity(String url, HttpMethod method, HttpEntity<?> requestEntity, Class<T> responseType, Map<String, ?> uriVariables) {
        URI uri = new UriTemplate(url).expand(uriVariables);
        HttpEntity<?> mergeRequestEntity = this.merge(requestEntity);
        RequestCallback requestCallback = this.restTemplate.httpEntityCallback(mergeRequestEntity, responseType);
        ResponseExtractor responseExtractor = this.restTemplate.responseEntityExtractor(responseType);
        return this.doExecute(uri, method, requestCallback, responseExtractor);
    }

    public void execute(String url, HttpMethod method, HttpEntity<?> requestEntity, Map<String, ?> uriVariables) {
        URI uri = new UriTemplate(url).expand(uriVariables);
        HttpEntity<?> mergeRequestEntity = this.merge(requestEntity);
        RequestCallback requestCallback = this.restTemplate.httpEntityCallback(mergeRequestEntity);
        this.doExecute(uri, method, requestCallback, null);
    }

    protected HttpEntity<Object> getHttpEntity(Object requestBody) {
        return new HttpEntity(requestBody);
    }

    private HttpEntity<?> merge(HttpEntity<?> httpEntity) {
        HttpHeaders httpHeaders = this.mergerHeaders(httpEntity.getHeaders());
        return new HttpEntity(httpEntity.getBody(), (MultiValueMap)httpHeaders);
    }

    protected <T> T doExecute(URI url, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor) {
        this.log.info("Http request begin. " + method + ": " + url);
        StopWatch sw = new StopWatch();
        sw.start();
        Object result = this.restTemplate.execute(url, method, requestCallback, responseExtractor);
        sw.stop();
        this.log.info("Http request end. Total millis: " + sw.getTotalTimeMillis() + " " + method + ": " + url);
        return (T)result;
    }

    public static class IdleConnectionMonitorThread
    extends Thread {
        private final HttpClientConnectionManager connMgr;
        private volatile boolean shutdown;

        public IdleConnectionMonitorThread(HttpClientConnectionManager connMgr) {
            this.connMgr = connMgr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                    synchronized (idleConnectionMonitorThread) {
                        this.wait(5000L);
                        this.connMgr.closeExpiredConnections();
                        this.connMgr.closeIdleConnections(30L, TimeUnit.SECONDS);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            IdleConnectionMonitorThread idleConnectionMonitorThread = this;
            synchronized (idleConnectionMonitorThread) {
                this.notifyAll();
            }
        }
    }

    private class RestRestTemplate
    extends RestTemplate {
        public RestRestTemplate(ClientHttpRequestFactory requestFactory) {
            super(requestFactory);
        }

        protected <T> RequestCallback acceptHeaderRequestCallback(Class<T> responseType) {
            return super.acceptHeaderRequestCallback(responseType);
        }

        protected <T> RequestCallback httpEntityCallback(Object requestBody) {
            return super.httpEntityCallback(requestBody);
        }

        protected <T> RequestCallback httpEntityCallback(Object requestBody, Type responseType) {
            return super.httpEntityCallback(requestBody, responseType);
        }

        protected <T> ResponseExtractor<ResponseEntity<T>> responseEntityExtractor(Type responseType) {
            return super.responseEntityExtractor(responseType);
        }

        protected <T> ResponseExtractor<T> httpMessageConverterExtractor(Type responseType) {
            return new HttpMessageConverterExtractor(responseType, this.getMessageConverters());
        }

        protected ClientHttpRequest createRequest(URI url, HttpMethod method) throws IOException {
            return new WafClientHttpRequest(super.createRequest(url, method));
        }
    }
}

