/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.client.http;

import com.crawler.client.ResourceAccessException;
import com.crawler.client.exception.ErrorMessage;
import com.crawler.client.http.WafClientHttpResponse;
import com.crawler.client.util.JsonMapper;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.DefaultResponseErrorHandler;

class WafApiErrorHandler
extends DefaultResponseErrorHandler {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    WafApiErrorHandler() {
    }

    public void handleError(ClientHttpResponse response) throws IOException {
        HttpStatus statusCode;
        WafClientHttpResponse wafResponse = (WafClientHttpResponse)response;
        ErrorMessage errorMessage = null;
        MultiValueMap headers = null;
        String responseText = IOUtils.toString((InputStream)wafResponse.getBody(), (String)"UTF-8");
        try {
            errorMessage = JsonMapper.parse(responseText, ErrorMessage.class);
            wafResponse.getHeaders();
            statusCode = wafResponse.getStatusCode();
        }
        catch (IOException ex) {
            String msg = "\u5c06 api \"" + wafResponse.getHttpMethod() + " " + wafResponse.getUri() + "\" \u7684\u54cd\u5e94\u5185\u5bb9 \"" + responseText + "\" \u8f6c\u6362\u4e3a " + ErrorMessage.class.toString() + " \u53d1\u751f\u5f02\u5e38\u3002";
            this.log.error(msg, (Throwable)ex);
            throw new IOException(msg, ex);
        }
        this.log.info("Remote api response error. Response content: ", (Object)responseText);
        ResponseEntity responseEntity = new ResponseEntity((Object)errorMessage, headers, statusCode);
        throw new ResourceAccessException((ResponseEntity<ErrorMessage>)responseEntity, wafResponse.getHttpMethod(), wafResponse.getUri());
    }
}

