/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.uc.utils;

import com.crawler.waf.config.JacksonObjectMapper;
import com.crawler.waqf.common.utils.StringUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisPubSub;

public class UcRedisManager {
    private static Logger logger = LoggerFactory.getLogger(UcRedisManager.class);
    private static JedisPool pool;
    private static int DB_INDEX;

    static {
        DB_INDEX = 0;
        try {
            Properties props = new Properties();
            props.load(UcRedisManager.class.getClassLoader().getResourceAsStream("redis.properties"));
            JedisPoolConfig config = new JedisPoolConfig();
            config.setMaxTotal(Integer.valueOf(props.getProperty("uc.redis.pool.maxTotal", props.getProperty("redis.pool.maxTotal"))).intValue());
            config.setMaxIdle(Integer.valueOf(props.getProperty("uc.redis.pool.maxIdle", props.getProperty("redis.pool.maxIdle"))).intValue());
            config.setMaxWaitMillis(Long.valueOf(props.getProperty("uc.redis.pool.maxWaitMillis", props.getProperty("redis.pool.maxWaitMillis"))).longValue());
            config.setTestOnBorrow(Boolean.valueOf(props.getProperty("uc.redis.pool.testOnBorrow", props.getProperty("redis.pool.testOnBorrow"))).booleanValue());
            config.setTestOnReturn(Boolean.valueOf(props.getProperty("uc.redis.pool.testOnReturn", props.getProperty("redis.pool.testOnReturn"))).booleanValue());
            String host = props.getProperty("uc.redis.host", props.getProperty("redis.host"));
            Integer port = Integer.valueOf(props.getProperty("uc.redis.port", props.getProperty("redis.port")));
            Integer timeout = Integer.valueOf(props.getProperty("uc.redis.timeout", props.getProperty("redis.timeout")));
            String password = props.getProperty("uc.redis.password", props.getProperty("redis.password"));
            DB_INDEX = Integer.valueOf(props.getProperty("uc.redis.dbindex", "15"));
            pool = password != null ? new JedisPool((GenericObjectPoolConfig)config, host, port.intValue(), timeout.intValue(), password) : new JedisPool((GenericObjectPoolConfig)config, host, port.intValue(), timeout.intValue());
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public static synchronized Jedis getJedis() {
        Jedis resource = null;
        try {
            if (pool != null) {
                resource = pool.getResource();
                resource.select(DB_INDEX);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        if (resource == null) {
            throw new NullPointerException("jedis is null, please check the redis server.");
        }
        return resource;
    }

    public static void close(Jedis jedis) {
        if (jedis != null) {
            jedis.close();
        }
    }

    public static void set(String key, Object data, int seconds) {
        String value = null;
        value = data instanceof String ? String.valueOf(data) : UcRedisManager.toJSONString(data);
        Jedis jedis = null;
        try {
            jedis = UcRedisManager.getJedis();
            if (seconds > 0) {
                jedis.setex(key, seconds, value);
            } else {
                jedis.set(key, value);
            }
        }
        finally {
            UcRedisManager.close(jedis);
        }
    }

    public static void set(String key, Object data) {
        String value = null;
        value = data instanceof String ? String.valueOf(data) : UcRedisManager.toJSONString(data);
        Jedis jedis = null;
        try {
            jedis = UcRedisManager.getJedis();
            jedis.set(key, value);
        }
        finally {
            UcRedisManager.close(jedis);
        }
    }

    public static <T> T get(String key, Class<T> clazz) {
        Jedis jedis = null;
        try {
            jedis = UcRedisManager.getJedis();
            String value = jedis.get(key);
            if (StringUtils.isEmpty((CharSequence)value)) {
                return null;
            }
            T t = UcRedisManager.parse(value, clazz);
            return t;
        }
        finally {
            UcRedisManager.close(jedis);
        }
    }

    public static String get(String key) {
        Jedis jedis = null;
        try {
            jedis = UcRedisManager.getJedis();
            String string = jedis.get(key);
            return string;
        }
        finally {
            UcRedisManager.close(jedis);
        }
    }

    public static void del(String key) {
        Jedis jedis = null;
        try {
            jedis = UcRedisManager.getJedis();
            jedis.del(key);
        }
        finally {
            UcRedisManager.close(jedis);
        }
    }

    public static String toJSONString(Object object) {
        JacksonObjectMapper objectMapper = new JacksonObjectMapper();
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return "";
        }
    }

    public static <T> T parse(String value, Class<T> clazz) {
        JacksonObjectMapper objectMapper = new JacksonObjectMapper();
        try {
            return (T)objectMapper.readValue(value, clazz);
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static void publish(String channel, Object obj) {
        try (Jedis jedis = null;){
            jedis = UcRedisManager.getJedis();
            String data = UcRedisManager.toJSONString(obj);
            jedis.publish(channel, data);
        }
    }

    public static void subscribe(JedisPubSub jedisPubSub, String ... channels) {
        try (Jedis jedis = null;){
            jedis = UcRedisManager.getJedis();
            jedis.subscribe(jedisPubSub, channels);
        }
    }
}

