/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.uc.utils;

import com.crawler.uc.utils.UcRedisManager;
import com.crawler.waf.config.WafProperties;
import com.crawler.waf.security.authens.OauthAccessToken;
import com.crawler.waf.utils.Encrypt;
import com.crawler.waf.utils.StringUtil;
import java.util.Date;
import java.util.Random;

public class UcSimulator {
    private static final String UC_TOKEN = "uc:token";
    private static final String UC_USER = "uc:user";
    private static final String ACCESS_TOKEN = "access";
    private static final String MAPPING = "mapping";
    private static final String REFRESH_TOKEN = "refresh";
    private static final String AUTH_CODE = "code";
    public static final int CODE_EXPIRE_MINUTE = WafProperties.getPropertyForInteger("code_expire_minute", "5");
    private static final int TOKEN_TIMEOUT = WafProperties.getPropertyForInteger("token.timeout", "7200");

    public static void saveCode(String code, Long userId) {
        int seconds = 60 * CODE_EXPIRE_MINUTE;
        UcRedisManager.set(UcSimulator.codeKey(code), userId, seconds);
    }

    public static Long findCode(String code) {
        return UcRedisManager.get(UcSimulator.codeKey(code), Long.class);
    }

    public static void removeCode(String code) {
        UcRedisManager.del(UcSimulator.codeKey(code));
    }

    public static OauthAccessToken generateBearerToken() {
        String tokenUserId = String.valueOf(0L);
        OauthAccessToken oauthAccessToken = new OauthAccessToken();
        String accessToken = UcSimulator.generateToken(tokenUserId);
        String refreshToken = UcSimulator.generateToken(tokenUserId);
        Date expiresAt = new Date(System.currentTimeMillis() + (long)(TOKEN_TIMEOUT * 60 * 1000));
        oauthAccessToken.setAccessToken(accessToken);
        oauthAccessToken.setRefreshToken(refreshToken);
        oauthAccessToken.setExpiresAt(expiresAt);
        oauthAccessToken.setUserId(tokenUserId);
        oauthAccessToken.setServerTime(new Date());
        UcSimulator.set("Bearer", oauthAccessToken);
        return oauthAccessToken;
    }

    public static void set(String type, OauthAccessToken oauthAccessToken) {
        Long userId = Long.parseLong(oauthAccessToken.getUserId());
        int seconds = (int)((oauthAccessToken.getExpiresAt().getTime() - System.currentTimeMillis()) / 1000L);
        if (seconds == 0) {
            oauthAccessToken.setExpiresAt(new Date(System.currentTimeMillis() + 3153600000000L));
        }
        UcRedisManager.set(UcSimulator.accessTokenKey(type, oauthAccessToken.getAccessToken()), oauthAccessToken, seconds);
        UcRedisManager.set(UcSimulator.refreshTokenKey(type, oauthAccessToken.getRefreshToken()), oauthAccessToken.getAccessToken(), seconds);
        UcRedisManager.set(UcSimulator.mappingKey(type, userId), oauthAccessToken.getAccessToken(), seconds);
    }

    public static OauthAccessToken get(String type, String accessToken) {
        return UcRedisManager.get(UcSimulator.accessTokenKey(type, accessToken), OauthAccessToken.class);
    }

    public static OauthAccessToken findByRefreshToken(String type, String refreshToken) {
        String accessToken = UcRedisManager.get(UcSimulator.refreshTokenKey(type, refreshToken));
        if (StringUtil.isNullOrEmpty(accessToken)) {
            return null;
        }
        return UcSimulator.get(type, accessToken);
    }

    public static void remove(String type, String accessToken) {
        OauthAccessToken oauthAccessToken = UcSimulator.get(type, accessToken);
        UcRedisManager.del(UcSimulator.accessTokenKey(type, accessToken));
        if (oauthAccessToken != null) {
            UcRedisManager.del(UcSimulator.refreshTokenKey(type, oauthAccessToken.getRefreshToken()));
        }
    }

    private static String userKey(Long userId) {
        return String.format("%s:%s", UC_USER, userId);
    }

    private static String mappingKey(String type, Long userId) {
        return String.format("%s:%s:%s:%s", UC_TOKEN, type, MAPPING, userId);
    }

    private static String accessTokenKey(String type, String accessToken) {
        return String.format("%s:%s:%s:%s", UC_TOKEN, type, ACCESS_TOKEN, accessToken);
    }

    private static String refreshTokenKey(String type, String refreshToken) {
        return String.format("%s:%s:%s:%s", UC_TOKEN, type, REFRESH_TOKEN, refreshToken);
    }

    private static String codeKey(String code) {
        return String.format("%s:%s:%s", UC_TOKEN, AUTH_CODE, code);
    }

    private static String generateToken(String userId) {
        return (String.valueOf(Encrypt.shortMd5(userId)) + Encrypt.SHA256(UcSimulator.getRandomString(8))).toUpperCase();
    }

    private static String getRandomString(int length) {
        String CHARS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        StringBuffer sb = new StringBuffer();
        Random random = new Random();
        int i = 0;
        while (i < length) {
            sb.append(CHARS.charAt(random.nextInt(CHARS.length())));
            ++i;
        }
        return sb.toString();
    }
}

