/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waf.exceptions;

import com.crawler.waf.exceptions.HandlerExceptionResolverBuilder;
import com.crawler.waf.exceptions.handlers.ExceptionHandler;
import com.crawler.waf.exceptions.support.HttpMessageConverterUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.accept.FixedContentNegotiationStrategy;
import org.springframework.web.accept.HeaderContentNegotiationStrategy;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.HttpEntityMethodProcessor;

public class HandlerExceptionResolver
extends AbstractHandlerExceptionResolver
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(HandlerExceptionResolver.class);
    private List<HttpMessageConverter<?>> messageConverters = HttpMessageConverterUtils.getDefaultHttpMessageConverters();
    private Map<Class<? extends Exception>, ExceptionHandler> handlers = new LinkedHashMap<Class<? extends Exception>, ExceptionHandler>();
    private MediaType defaultContentType = MediaType.APPLICATION_XML;
    private ContentNegotiationManager contentNegotiationManager;
    HandlerMethodReturnValueHandler responseProcessor;
    HandlerMethodReturnValueHandler fallbackResponseProcessor;

    public static HandlerExceptionResolverBuilder builder() {
        return new HandlerExceptionResolverBuilder();
    }

    public void afterPropertiesSet() {
        if (this.contentNegotiationManager == null) {
            this.contentNegotiationManager = new ContentNegotiationManager(new ContentNegotiationStrategy[]{new HeaderContentNegotiationStrategy(), new FixedContentNegotiationStrategy(this.defaultContentType)});
        }
        this.responseProcessor = new HttpEntityMethodProcessor(this.messageConverters, this.contentNegotiationManager);
        this.fallbackResponseProcessor = new HttpEntityMethodProcessor(this.messageConverters, new ContentNegotiationManager(new ContentNegotiationStrategy[]{new FixedContentNegotiationStrategy(this.defaultContentType)}));
    }

    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception exception) {
        ResponseEntity<?> entity;
        try {
            entity = this.handleException(exception, request);
        }
        catch (NoExceptionHandlerFoundException ex) {
            LOG.warn("No exception handler found to handle exception: {}", (Object)exception.getClass().getName());
            return null;
        }
        try {
            this.processResponse(entity, (NativeWebRequest)new ServletWebRequest(request, response));
        }
        catch (Exception ex) {
            LOG.error("Failed to process error response: {}", entity, (Object)ex);
            return null;
        }
        return new ModelAndView();
    }

    protected ResponseEntity<?> handleException(Exception exception, HttpServletRequest request) {
        request.removeAttribute(HandlerMapping.PRODUCIBLE_MEDIA_TYPES_ATTRIBUTE);
        ExceptionHandler handler = this.resolveExceptionHandler(exception.getClass());
        LOG.debug("Handling exception {} with response factory: {}", (Object)exception.getClass().getName(), (Object)handler);
        return handler.handleException(exception, request);
    }

    protected ExceptionHandler resolveExceptionHandler(Class<? extends Exception> exceptionClass) {
        Class<? extends Exception> clazz = exceptionClass;
        while (clazz != Throwable.class) {
            if (this.handlers.containsKey(clazz)) {
                return this.handlers.get(clazz);
            }
            clazz = clazz.getSuperclass();
        }
        throw new NoExceptionHandlerFoundException();
    }

    protected void processResponse(ResponseEntity<?> entity, NativeWebRequest webRequest) throws Exception {
        ModelAndViewContainer mavContainer = new ModelAndViewContainer();
        try {
            this.responseProcessor.handleReturnValue(entity, null, mavContainer, webRequest);
        }
        catch (HttpMediaTypeNotAcceptableException ex) {
            LOG.debug("Requested media type is not supported, falling back to default one");
            this.fallbackResponseProcessor.handleReturnValue(entity, null, mavContainer, webRequest);
        }
    }

    public List<HttpMessageConverter<?>> getMessageConverters() {
        return this.messageConverters;
    }

    public void setMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        Assert.notNull(messageConverters, (String)"messageConverters must not be null");
        this.messageConverters = messageConverters;
    }

    public ContentNegotiationManager getContentNegotiationManager() {
        return this.contentNegotiationManager;
    }

    public void setContentNegotiationManager(ContentNegotiationManager contentNegotiationManager) {
        this.contentNegotiationManager = contentNegotiationManager != null ? contentNegotiationManager : new ContentNegotiationManager();
    }

    public MediaType getDefaultContentType() {
        return this.defaultContentType;
    }

    public void setDefaultContentType(MediaType defaultContentType) {
        this.defaultContentType = defaultContentType;
    }

    public Map<Class<? extends Exception>, ExceptionHandler> getExceptionHandlers() {
        return this.handlers;
    }

    public void setExceptionHandlers(Map<Class<? extends Exception>, ExceptionHandler> handlers) {
        this.handlers = handlers;
    }

    public static class NoExceptionHandlerFoundException
    extends RuntimeException {
    }
}

