/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waf.exceptions;

import com.crawler.waf.exceptions.HandlerExceptionResolver;
import com.crawler.waf.exceptions.MapUtils;
import com.crawler.waf.exceptions.handlers.AbstractWafExceptionHandler;
import com.crawler.waf.exceptions.handlers.CustomExceptionHandler;
import com.crawler.waf.exceptions.handlers.ExceptionHandler;
import com.crawler.waf.exceptions.support.ErrorMessageMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.StringUtils;
import org.springframework.web.accept.ContentNegotiationManager;

public class HandlerExceptionResolverBuilder {
    private final Map<Class, ExceptionHandler> exceptionHandlers = new HashMap<Class, ExceptionHandler>();
    private MediaType defaultContentType;
    private ContentNegotiationManager contentNegotiationManager;
    private List<HttpMessageConverter<?>> httpMessageConverters;
    private boolean withDefaultHandlers = true;

    public HandlerExceptionResolver build() {
        if (this.withDefaultHandlers) {
            MapUtils.putAllIfAbsent(this.exceptionHandlers, this.getDefaultHandlers());
        }
        HandlerExceptionResolver resolver = new HandlerExceptionResolver();
        resolver.setExceptionHandlers(this.exceptionHandlers);
        if (this.httpMessageConverters != null) {
            resolver.setMessageConverters(this.httpMessageConverters);
        }
        if (this.contentNegotiationManager != null) {
            resolver.setContentNegotiationManager(this.contentNegotiationManager);
        }
        if (this.defaultContentType != null) {
            resolver.setDefaultContentType(this.defaultContentType);
        }
        resolver.afterPropertiesSet();
        return resolver;
    }

    public HandlerExceptionResolverBuilder defaultContentType(MediaType mediaType) {
        this.defaultContentType = mediaType;
        return this;
    }

    public HandlerExceptionResolverBuilder defaultContentType(String mediaType) {
        this.defaultContentType(StringUtils.hasText((String)mediaType) ? MediaType.parseMediaType((String)mediaType) : null);
        return this;
    }

    public HandlerExceptionResolverBuilder addHandler(Class<?> exceptionClass, ExceptionHandler exceptionHandler) {
        this.exceptionHandlers.put(exceptionClass, exceptionHandler);
        return this;
    }

    public HandlerExceptionResolverBuilder addHandler(AbstractWafExceptionHandler exceptionHandler) {
        return this.addHandler(exceptionHandler.getExceptionClass(), exceptionHandler);
    }

    public HandlerExceptionResolverBuilder addErrorMessageHandler(Class<?> exceptionClass, HttpStatus status) {
        return this.addHandler(new CustomExceptionHandler(exceptionClass, status));
    }

    private Map<Class, ExceptionHandler> getDefaultHandlers() {
        HashMap<Class, ExceptionHandler> map = new HashMap<Class, ExceptionHandler>();
        ErrorMessageMapper[] errorMessageMapperArray = ErrorMessageMapper.values();
        int n = errorMessageMapperArray.length;
        int n2 = 0;
        while (n2 < n) {
            ErrorMessageMapper item = errorMessageMapperArray[n2];
            this.addHandler(item.getExClass(), item.getHandler());
            ++n2;
        }
        return map;
    }

    private void addHandlerTo(Map<Class<?>, ExceptionHandler> map, Class<?> exceptionClass, HttpStatus status) {
        map.put(exceptionClass, new CustomExceptionHandler(exceptionClass, status));
    }

    public MediaType getDefaultContentType() {
        return this.defaultContentType;
    }

    public void setDefaultContentType(MediaType defaultContentType) {
        this.defaultContentType = defaultContentType;
    }

    public ContentNegotiationManager getContentNegotiationManager() {
        return this.contentNegotiationManager;
    }

    public void setContentNegotiationManager(ContentNegotiationManager contentNegotiationManager) {
        this.contentNegotiationManager = contentNegotiationManager;
    }

    public List<HttpMessageConverter<?>> getHttpMessageConverters() {
        return this.httpMessageConverters;
    }

    public void setHttpMessageConverters(List<HttpMessageConverter<?>> httpMessageConverters) {
        this.httpMessageConverters = httpMessageConverters;
    }

    public boolean isWithDefaultHandlers() {
        return this.withDefaultHandlers;
    }

    public void setWithDefaultHandlers(boolean withDefaultHandlers) {
        this.withDefaultHandlers = withDefaultHandlers;
    }

    public Map<Class, ExceptionHandler> getExceptionHandlers() {
        return this.exceptionHandlers;
    }
}

