/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waf.exceptions.handlers;

import com.crawler.waf.exceptions.extendExceptions.CustomExceptionSupport;
import com.crawler.waf.exceptions.extendExceptions.ExceptionSupport;
import com.crawler.waf.exceptions.handlers.ExceptionHandler;
import com.crawler.waf.exceptions.providers.DefaultErrorMessageProvider;
import com.crawler.waf.exceptions.providers.ErrorMessageProvider;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public abstract class AbstractWafExceptionHandler
implements ExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionHandler.class);
    private Class<?> exceptionClass = null;
    private HttpStatus status;
    private ErrorMessageProvider provider = new DefaultErrorMessageProvider();

    protected AbstractWafExceptionHandler(HttpStatus status) {
        this.status = status;
    }

    protected AbstractWafExceptionHandler(Class<?> exceptionClass) {
        this.exceptionClass = exceptionClass;
    }

    protected AbstractWafExceptionHandler(HttpStatus status, ErrorMessageProvider provider) {
        this.provider = provider;
        this.status = status;
    }

    protected AbstractWafExceptionHandler(Class<?> exceptionClass, HttpStatus status, ErrorMessageProvider provider) {
        this.exceptionClass = exceptionClass;
        this.status = status;
        this.provider = provider;
    }

    protected AbstractWafExceptionHandler(Class<?> exceptionClass, HttpStatus status) {
        this.exceptionClass = exceptionClass;
        this.status = status;
    }

    public abstract Object createBody(Exception var1, HttpServletRequest var2);

    @Override
    public ResponseEntity<?> handleException(Exception ex, HttpServletRequest req) {
        if (ExceptionSupport.class.isInstance(ex)) {
            this.status = ((ExceptionSupport)((Object)ex)).getStatus();
        }
        this.logException(ex, req);
        Object body = this.createBody(ex, req);
        HttpHeaders headers = this.createHeaders(ex, req);
        return new ResponseEntity(body, (MultiValueMap)headers, this.getStatus());
    }

    public Class<?> getExceptionClass() {
        return this.exceptionClass;
    }

    public HttpStatus getStatus() {
        if (this.status == null) {
            this.status = HttpStatus.INTERNAL_SERVER_ERROR;
        }
        return this.status;
    }

    protected HttpHeaders createHeaders(Exception ex, HttpServletRequest req) {
        return new HttpHeaders();
    }

    protected void logException(Exception ex, HttpServletRequest req) {
        if (LOG.isErrorEnabled() && this.getStatus().value() >= 500 || LOG.isInfoEnabled()) {
            Marker marker = MarkerFactory.getMarker((String)ex.getClass().getName());
            String uri = req.getRequestURI();
            if (req.getQueryString() != null) {
                uri = String.valueOf(uri) + '?' + req.getQueryString();
            }
            String msg = String.format("%s %s ~> %s", req.getMethod(), uri, this.getStatus());
            if (this.getStatus().value() >= 500) {
                if (ex instanceof CustomExceptionSupport) {
                    LOG.error(marker, String.valueOf(msg) + "\n" + ex.getMessage());
                } else {
                    LOG.error(marker, msg, (Throwable)ex);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug(marker, msg, (Throwable)ex);
            } else {
                LOG.info(marker, msg);
            }
        }
    }

    public ErrorMessageProvider getProvider() {
        return this.provider;
    }
}

