/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waf.exceptions.messages;

import com.crawler.waf.exceptions.messages.ErrorMessage;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class ValidationErrorMessage
extends ErrorMessage {
    private static final long serialVersionUID = 1L;
    private List<Error> errors = new ArrayList<Error>(6);

    public ValidationErrorMessage(String code, String message, String hostId, String requestId, Date serverTime, URI type, List<Error> errors) {
        super(code, message, hostId, requestId, serverTime, type);
        this.errors = errors;
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public void setErrors(List<Error> errors) {
        this.errors = errors;
    }

    public ValidationErrorMessage addError(String field, Object rejectedValue, String message) {
        Error error = new Error();
        error.setField(field);
        error.setMessage(message);
        error.setRejected(rejectedValue);
        this.errors.add(error);
        return this;
    }

    public ValidationErrorMessage addError(String message) {
        Error error = new Error();
        error.setMessage(message);
        this.errors.add(error);
        return this;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    static class Error {
        private String field;
        private Object rejected;
        private String message;

        Error() {
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public Object getRejected() {
            return this.rejected;
        }

        public void setRejected(Object rejected) {
            this.rejected = rejected;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

