/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waqf.common.persistence;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.mapper.MapperScannerConfigurer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.NestedIOException;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class MapperLoader
implements DisposableBean,
InitializingBean,
ApplicationContextAware {
    private ConfigurableApplicationContext context = null;
    private transient String basePackage = null;
    private HashMap<String, String> fileMapping = new HashMap();
    private Scanner scanner = null;
    private ScheduledExecutorService service = null;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = (ConfigurableApplicationContext)applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        try {
            this.service = Executors.newScheduledThreadPool(1);
            MapperScannerConfigurer config = (MapperScannerConfigurer)this.context.getBean(MapperScannerConfigurer.class);
            Field field = config.getClass().getDeclaredField("basePackage");
            field.setAccessible(true);
            this.basePackage = (String)field.get(config);
            this.scanner = new Scanner();
            this.scanner.scan();
            this.service.scheduleAtFixedRate(new Task(), 5L, 5L, TimeUnit.SECONDS);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void destroy() throws Exception {
        if (this.service != null) {
            this.service.shutdownNow();
        }
    }

    class Scanner {
        private String[] basePackages;
        private static final String XML_RESOURCE_PATTERN = "**/*.xml";
        private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();

        public Scanner() {
            this.basePackages = StringUtils.tokenizeToStringArray((String)MapperLoader.this.basePackage, (String)",; \t\n");
        }

        public Resource[] getResource(String basePackage, String pattern) throws IOException {
            String packageSearchPath = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)MapperLoader.this.context.getEnvironment().resolveRequiredPlaceholders(basePackage)) + "/" + pattern;
            Resource[] resources = this.resourcePatternResolver.getResources(packageSearchPath);
            return resources;
        }

        public void reloadXML() throws Exception {
            SqlSessionFactory factory = (SqlSessionFactory)MapperLoader.this.context.getBean(SqlSessionFactory.class);
            Configuration configuration = factory.getConfiguration();
            this.removeConfig(configuration);
            String[] stringArray = this.basePackages;
            int n = this.basePackages.length;
            int n2 = 0;
            while (n2 < n) {
                String basePackage = stringArray[n2];
                Resource[] resources = this.getResource(basePackage, XML_RESOURCE_PATTERN);
                if (resources != null) {
                    int i = 0;
                    while (i < resources.length) {
                        if (resources[i] != null) {
                            try {
                                try {
                                    XMLMapperBuilder xmlMapperBuilder = new XMLMapperBuilder(resources[i].getInputStream(), configuration, resources[i].toString(), configuration.getSqlFragments());
                                    xmlMapperBuilder.parse();
                                }
                                catch (Exception e) {
                                    throw new NestedIOException("Failed to parse mapping resource: '" + resources[i] + "'", (Throwable)e);
                                }
                            }
                            finally {
                                ErrorContext.instance().reset();
                            }
                        }
                        ++i;
                    }
                }
                ++n2;
            }
        }

        private void removeConfig(Configuration configuration) throws Exception {
            Class<?> classConfig = configuration.getClass();
            this.clearMap(classConfig, configuration, "mappedStatements");
            this.clearMap(classConfig, configuration, "caches");
            this.clearMap(classConfig, configuration, "resultMaps");
            this.clearMap(classConfig, configuration, "parameterMaps");
            this.clearMap(classConfig, configuration, "keyGenerators");
            this.clearMap(classConfig, configuration, "sqlFragments");
            this.clearSet(classConfig, configuration, "loadedResources");
        }

        private void clearMap(Class<?> classConfig, Configuration configuration, String fieldName) throws Exception {
            Field field = classConfig.getDeclaredField(fieldName);
            field.setAccessible(true);
            Map mapConfig = (Map)field.get(configuration);
            mapConfig.clear();
        }

        private void clearSet(Class<?> classConfig, Configuration configuration, String fieldName) throws Exception {
            Field field = classConfig.getDeclaredField(fieldName);
            field.setAccessible(true);
            Set setConfig = (Set)field.get(configuration);
            setConfig.clear();
        }

        public void scan() throws IOException {
            if (!MapperLoader.this.fileMapping.isEmpty()) {
                return;
            }
            String[] stringArray = this.basePackages;
            int n = this.basePackages.length;
            int n2 = 0;
            while (n2 < n) {
                String basePackage = stringArray[n2];
                Resource[] resources = this.getResource(basePackage, XML_RESOURCE_PATTERN);
                if (resources != null) {
                    int i = 0;
                    while (i < resources.length) {
                        String multi_key = this.getValue(resources[i]);
                        MapperLoader.this.fileMapping.put(resources[i].getFilename(), multi_key);
                        ++i;
                    }
                }
                ++n2;
            }
        }

        private String getValue(Resource resource) throws IOException {
            String contentLength = String.valueOf(resource.contentLength());
            String lastModified = String.valueOf(resource.lastModified());
            return contentLength + lastModified;
        }

        public boolean isChanged() throws IOException {
            boolean isChanged = false;
            String[] stringArray = this.basePackages;
            int n = this.basePackages.length;
            int n2 = 0;
            while (n2 < n) {
                String basePackage = stringArray[n2];
                Resource[] resources = this.getResource(basePackage, XML_RESOURCE_PATTERN);
                if (resources != null) {
                    int i = 0;
                    while (i < resources.length) {
                        String name = resources[i].getFilename();
                        String value = (String)MapperLoader.this.fileMapping.get(name);
                        String multi_key = this.getValue(resources[i]);
                        if (!multi_key.equals(value)) {
                            isChanged = true;
                            MapperLoader.this.fileMapping.put(name, multi_key);
                        }
                        ++i;
                    }
                }
                ++n2;
            }
            return isChanged;
        }
    }

    class Task
    implements Runnable {
        Task() {
        }

        @Override
        public void run() {
            try {
                if (MapperLoader.this.scanner.isChanged()) {
                    System.out.println("*Mapper.xml\u6587\u4ef6\u6539\u53d8,\u91cd\u65b0\u52a0\u8f7d.");
                    MapperLoader.this.scanner.reloadXML();
                    System.out.println("\u52a0\u8f7d\u5b8c\u6bd5.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

