/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waqf.common.persistence.proxy;

import com.crawler.waqf.common.persistence.Page;
import com.crawler.waqf.common.persistence.proxy.PaginationMapperMethod;
import com.crawler.waqf.common.utils.Reflections;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Set;
import org.apache.ibatis.binding.BindingException;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.session.SqlSession;

public class PaginationMapperProxy
implements InvocationHandler {
    private static final Set<String> OBJECT_METHODS = new HashSet<String>(){
        private static final long serialVersionUID = -1782950882770203583L;
        {
            this.add("toString");
            this.add("getClass");
            this.add("hashCode");
            this.add("equals");
            this.add("wait");
            this.add("notify");
            this.add("notifyAll");
        }
    };
    private final SqlSession sqlSession;

    private boolean isObjectMethod(Method method) {
        return OBJECT_METHODS.contains(method.getName());
    }

    private PaginationMapperProxy(SqlSession sqlSession) {
        this.sqlSession = sqlSession;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.isObjectMethod(method)) {
            return null;
        }
        Class<?> declaringInterface = this.findDeclaringInterface(proxy, method);
        if (Page.class.isAssignableFrom(method.getReturnType())) {
            return new PaginationMapperMethod(declaringInterface, method, this.sqlSession).execute(args);
        }
        MapperMethod mapperMethod = new MapperMethod(declaringInterface, method, this.sqlSession.getConfiguration());
        Object result = mapperMethod.execute(this.sqlSession, args);
        if (result == null && method.getReturnType().isPrimitive()) {
            throw new BindingException("Mapper method '" + method.getName() + "' (" + method.getDeclaringClass() + ") attempted to return null from a method with a primitive return type (" + method.getReturnType() + ").");
        }
        return result;
    }

    private Class<?> findDeclaringInterface(Object proxy, Method method) {
        Class<?> declaringInterface = null;
        Class<?>[] classArray = proxy.getClass().getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> mapperFaces = classArray[n2];
            Method m = Reflections.getAccessibleMethod(mapperFaces, method.getName(), method.getParameterTypes());
            if (m != null) {
                declaringInterface = mapperFaces;
            }
            ++n2;
        }
        if (declaringInterface == null) {
            throw new BindingException("Could not find interface with the given method " + method);
        }
        return declaringInterface;
    }

    public static <T> T newMapperProxy(Class<T> mapperInterface, SqlSession sqlSession) {
        ClassLoader classLoader = mapperInterface.getClassLoader();
        Class[] interfaces = new Class[]{mapperInterface};
        PaginationMapperProxy proxy = new PaginationMapperProxy(sqlSession);
        return (T)Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)proxy);
    }
}

