/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waqf.common.utils.excel;

import com.crawler.waqf.common.utils.Reflections;
import com.crawler.waqf.common.utils.excel.annotation.ExcelField;
import com.crawler.waqf.modules.sys.entity.Area;
import com.crawler.waqf.modules.sys.entity.User;
import com.crawler.waqf.modules.sys.utils.DictUtils;
import com.crawler.waqf.modules.sys.utils.UserUtils;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class ImportExcel {
    private static Logger log = LoggerFactory.getLogger(ImportExcel.class);
    private Workbook wb;
    private Sheet sheet;
    private int headerNum;

    public ImportExcel(String fileName, int headerNum) throws InvalidFormatException, IOException {
        this(new File(fileName), headerNum);
    }

    public ImportExcel(File file, int headerNum) throws InvalidFormatException, IOException {
        this(file, headerNum, 0);
    }

    public ImportExcel(String fileName, int headerNum, int sheetIndex) throws InvalidFormatException, IOException {
        this(new File(fileName), headerNum, sheetIndex);
    }

    public ImportExcel(File file, int headerNum, int sheetIndex) throws InvalidFormatException, IOException {
        this(file.getName(), new FileInputStream(file), headerNum, sheetIndex);
    }

    public ImportExcel(MultipartFile multipartFile, int headerNum, int sheetIndex) throws InvalidFormatException, IOException {
        this(multipartFile.getOriginalFilename(), multipartFile.getInputStream(), headerNum, sheetIndex);
    }

    public ImportExcel(String fileName, InputStream is, int headerNum, int sheetIndex) throws InvalidFormatException, IOException {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            throw new RuntimeException("\u5bfc\u5165\u6587\u6863\u4e3a\u7a7a!");
        }
        if (fileName.toLowerCase().endsWith("xls")) {
            this.wb = new HSSFWorkbook(is);
        } else if (fileName.toLowerCase().endsWith("xlsx")) {
            this.wb = new XSSFWorkbook(is);
        } else {
            throw new RuntimeException("\u6587\u6863\u683c\u5f0f\u4e0d\u6b63\u786e!");
        }
        if (this.wb.getNumberOfSheets() < sheetIndex) {
            throw new RuntimeException("\u6587\u6863\u4e2d\u6ca1\u6709\u5de5\u4f5c\u8868!");
        }
        this.sheet = this.wb.getSheetAt(sheetIndex);
        this.headerNum = headerNum;
        log.debug("Initialize success.");
    }

    public Row getRow(int rownum) {
        return this.sheet.getRow(rownum);
    }

    public int getDataRowNum() {
        return this.headerNum + 1;
    }

    public int getLastDataRowNum() {
        return this.sheet.getLastRowNum() + this.headerNum;
    }

    public int getLastCellNum() {
        return this.getRow(this.headerNum).getLastCellNum();
    }

    public Object getCellValue(Row row, int column) {
        Object val = "";
        try {
            Cell cell = row.getCell(column);
            if (cell != null) {
                if (cell.getCellType() == 0) {
                    if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                        double d = cell.getNumericCellValue();
                        Date date = HSSFDateUtil.getJavaDate((double)d);
                        SimpleDateFormat dformat = new SimpleDateFormat("yyyy-MM-dd");
                        val = dformat.format(date);
                    } else {
                        NumberFormat nf = NumberFormat.getInstance();
                        nf.setGroupingUsed(false);
                        val = nf.format(cell.getNumericCellValue());
                    }
                } else if (cell.getCellType() == 1) {
                    val = cell.getStringCellValue();
                } else if (cell.getCellType() == 2) {
                    val = cell.getCellFormula();
                } else if (cell.getCellType() == 4) {
                    val = cell.getBooleanCellValue();
                } else if (cell.getCellType() == 5) {
                    val = cell.getErrorCellValue();
                }
            }
        }
        catch (Exception e) {
            return val;
        }
        return val;
    }

    public <E> List<E> getDataList(Class<E> cls, int ... groups) throws InstantiationException, IllegalAccessException {
        int n;
        int n2;
        Object ef;
        Field[] fs;
        ArrayList annotationList = Lists.newArrayList();
        Field[] fieldArray = fs = cls.getDeclaredFields();
        int n3 = fs.length;
        int n4 = 0;
        while (n4 < n3) {
            Field f = fieldArray[n4];
            ef = f.getAnnotation(ExcelField.class);
            if (ef != null && (ef.type() == 0 || ef.type() == 2)) {
                if (groups != null && groups.length > 0) {
                    boolean inGroup = false;
                    int[] nArray = groups;
                    n2 = groups.length;
                    int n5 = 0;
                    while (n5 < n2) {
                        int g = nArray[n5];
                        if (!inGroup) {
                            int[] nArray2 = ef.groups();
                            n = nArray2.length;
                            int n6 = 0;
                            while (n6 < n) {
                                int efg = nArray2[n6];
                                if (g == efg) {
                                    inGroup = true;
                                    annotationList.add(new Object[]{ef, f});
                                    break;
                                }
                                ++n6;
                            }
                            ++n5;
                            continue;
                        }
                        break;
                    }
                } else {
                    annotationList.add(new Object[]{ef, f});
                }
            }
            ++n4;
        }
        Method[] ms = cls.getDeclaredMethods();
        ef = ms;
        int n7 = ms.length;
        n3 = 0;
        while (n3 < n7) {
            Object m = ef[n3];
            ExcelField ef2 = ((Method)m).getAnnotation(ExcelField.class);
            if (ef2 != null && (ef2.type() == 0 || ef2.type() == 2)) {
                if (groups != null && groups.length > 0) {
                    boolean inGroup = false;
                    int[] efg = groups;
                    int n8 = groups.length;
                    n2 = 0;
                    while (n2 < n8) {
                        int g = efg[n2];
                        if (!inGroup) {
                            int[] nArray = ef2.groups();
                            int n9 = nArray.length;
                            n = 0;
                            while (n < n9) {
                                int efg2 = nArray[n];
                                if (g == efg2) {
                                    inGroup = true;
                                    annotationList.add(new Object[]{ef2, m});
                                    break;
                                }
                                ++n;
                            }
                            ++n2;
                            continue;
                        }
                        break;
                    }
                } else {
                    annotationList.add(new Object[]{ef2, m});
                }
            }
            ++n3;
        }
        Collections.sort(annotationList, new Comparator<Object[]>(){

            @Override
            public int compare(Object[] o1, Object[] o2) {
                return new Integer(((ExcelField)o1[0]).sort()).compareTo(new Integer(((ExcelField)o2[0]).sort()));
            }
        });
        ArrayList dataList = Lists.newArrayList();
        int i = this.getDataRowNum();
        while (i < this.getLastDataRowNum()) {
            E e = cls.newInstance();
            int column = 0;
            Row row = this.getRow(i);
            StringBuilder sb = new StringBuilder();
            for (Object[] os : annotationList) {
                Object val;
                if ((val = this.getCellValue(row, column++)) != null) {
                    ExcelField ef3 = (ExcelField)os[0];
                    if (StringUtils.isNotBlank((CharSequence)ef3.dictType())) {
                        val = DictUtils.getDictValue(val.toString(), ef3.dictType(), "");
                    }
                    Class valType = Class.class;
                    if (os[1] instanceof Field) {
                        valType = ((Field)os[1]).getType();
                    } else if (os[1] instanceof Method) {
                        Method method = (Method)os[1];
                        if ("get".equals(method.getName().substring(0, 3))) {
                            valType = method.getReturnType();
                        } else if ("set".equals(method.getName().substring(0, 3))) {
                            valType = ((Method)os[1]).getParameterTypes()[0];
                        }
                    }
                    try {
                        if (valType == String.class) {
                            String s = String.valueOf(val.toString());
                            val = StringUtils.endsWith((CharSequence)s, (CharSequence)".0") ? StringUtils.substringBefore((String)s, (String)".0") : String.valueOf(val.toString());
                        } else if (valType == Integer.class) {
                            val = Double.valueOf(val.toString()).intValue();
                        } else if (valType == Long.class) {
                            val = Double.valueOf(val.toString()).longValue();
                        } else if (valType == Double.class) {
                            val = Double.valueOf(val.toString());
                        } else if (valType == Float.class) {
                            val = Float.valueOf(val.toString());
                        } else if (valType == Date.class) {
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                            val = sdf.parse(val.toString());
                        } else {
                            val = valType == User.class ? UserUtils.getByUserName(val.toString()) : (valType == Area.class ? UserUtils.getByAreaName(val.toString()) : (ef3.fieldType() != Class.class ? ef3.fieldType().getMethod("getValue", String.class).invoke(null, val.toString()) : Class.forName(this.getClass().getName().replaceAll(this.getClass().getSimpleName(), "fieldtype." + valType.getSimpleName() + "Type")).getMethod("getValue", String.class).invoke(null, val.toString())));
                        }
                    }
                    catch (Exception ex) {
                        log.info("Get cell value [" + i + "," + column + "] error: " + ex.toString());
                        val = null;
                    }
                    if (os[1] instanceof Field) {
                        Reflections.invokeSetter(e, ((Field)os[1]).getName(), val);
                    } else if (os[1] instanceof Method) {
                        String mthodName = ((Method)os[1]).getName();
                        if ("get".equals(mthodName.substring(0, 3))) {
                            mthodName = "set" + StringUtils.substringAfter((String)mthodName, (String)"get");
                        }
                        Reflections.invokeMethod(e, mthodName, new Class[]{valType}, new Object[]{val});
                    }
                }
                sb.append(val + ", ");
            }
            dataList.add(e);
            log.debug("Read success: [" + i + "] " + sb.toString());
            ++i;
        }
        return dataList;
    }
}

