/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waqf.common.web;

import com.crawler.waqf.common.beanvalidator.BeanValidators;
import com.crawler.waqf.common.mapper.JsonMapper;
import com.crawler.waqf.common.utils.DateUtils;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolationException;
import javax.validation.ValidationException;
import javax.validation.Validator;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.ui.Model;
import org.springframework.validation.BindException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

public abstract class BaseController {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${adminPath}")
    protected String adminPath;
    @Value(value="${frontPath}")
    protected String frontPath;
    @Value(value="${urlSuffix}")
    protected String urlSuffix;
    @Autowired
    protected Validator validator;

    protected boolean beanValidator(Model model, Object object, Class<?> ... groups) {
        try {
            BeanValidators.validateWithException(this.validator, object, groups);
        }
        catch (ConstraintViolationException ex) {
            List<String> list = BeanValidators.extractPropertyAndMessageAsList(ex, ": ");
            list.add(0, "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff1a");
            this.addMessage(model, list.toArray(new String[0]));
            return false;
        }
        return true;
    }

    protected boolean beanValidator(RedirectAttributes redirectAttributes, Object object, Class<?> ... groups) {
        try {
            BeanValidators.validateWithException(this.validator, object, groups);
        }
        catch (ConstraintViolationException ex) {
            List<String> list = BeanValidators.extractPropertyAndMessageAsList(ex, ": ");
            list.add(0, "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff1a");
            this.addMessage(redirectAttributes, list.toArray(new String[0]));
            return false;
        }
        return true;
    }

    protected void beanValidator(Object object, Class<?> ... groups) {
        BeanValidators.validateWithException(this.validator, object, groups);
    }

    protected void addMessage(Model model, String ... messages) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = messages;
        int n = messages.length;
        int n2 = 0;
        while (n2 < n) {
            String message = stringArray[n2];
            sb.append(message).append(messages.length > 1 ? "<br/>" : "");
            ++n2;
        }
        model.addAttribute("message", (Object)sb.toString());
    }

    protected void addMessage(RedirectAttributes redirectAttributes, String ... messages) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = messages;
        int n = messages.length;
        int n2 = 0;
        while (n2 < n) {
            String message = stringArray[n2];
            sb.append(message).append(messages.length > 1 ? "<br/>" : "");
            ++n2;
        }
        redirectAttributes.addFlashAttribute("message", (Object)sb.toString());
    }

    protected String renderString(HttpServletResponse response, Object object) {
        return this.renderString(response, JsonMapper.toJsonString(object));
    }

    protected String renderString(HttpServletResponse response, String string) {
        try {
            response.reset();
            response.setContentType("application/json");
            response.setCharacterEncoding("utf-8");
            response.getWriter().print(string);
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @ExceptionHandler(value={BindException.class, ConstraintViolationException.class, ValidationException.class})
    public String bindException() {
        return "error/400";
    }

    @ExceptionHandler(value={AuthenticationException.class})
    public String authenticationException() {
        return "error/403";
    }

    @InitBinder
    protected void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(String.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                this.setValue(text == null ? null : StringEscapeUtils.escapeHtml4((String)text.trim()));
            }

            @Override
            public String getAsText() {
                Object value = this.getValue();
                return value != null ? value.toString() : "";
            }
        });
        binder.registerCustomEditor(Date.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                this.setValue(DateUtils.parseDate(text));
            }
        });
    }
}

