/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waqf.modules.sys.entity;

import com.crawler.waqf.common.persistence.DataEntity;
import com.crawler.waqf.modules.sys.utils.UserUtils;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;

public class Menu
extends DataEntity<Menu> {
    private static final long serialVersionUID = 1L;
    private Menu parent;
    private String parentIds;
    private List<Menu> children;
    private String name;
    private String href;
    private String target;
    private String icon;
    private Integer sort;
    private String isShow;
    private String permission;
    private String userId;

    public Menu() {
        this.sort = 30;
        this.isShow = "1";
    }

    public Menu(String id) {
        super(id);
    }

    @JsonBackReference
    @NotNull
    public Menu getParent() {
        return this.parent;
    }

    public void setParent(Menu parent) {
        this.parent = parent;
    }

    @Length(min=1, max=2000)
    public String getParentIds() {
        return this.parentIds;
    }

    public void setParentIds(String parentIds) {
        this.parentIds = parentIds;
    }

    @Length(min=1, max=100)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Length(min=0, max=2000)
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    @Length(min=0, max=20)
    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    @Length(min=0, max=100)
    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    @NotNull
    public Integer getSort() {
        return this.sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    @Length(min=1, max=1)
    public String getIsShow() {
        return this.isShow;
    }

    public void setIsShow(String isShow) {
        this.isShow = isShow;
    }

    @Length(min=0, max=200)
    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public String getParentId() {
        return this.parent != null && this.parent.getId() != null ? this.parent.getId() : "0";
    }

    @JsonIgnore
    public boolean hasPermisson() {
        List<Menu> menuList = UserUtils.getMenuList();
        for (Menu menu : menuList) {
            if (!menu.getId().equals(this.getId())) continue;
            return true;
        }
        return false;
    }

    @JsonIgnore
    public static void sortList(List<Menu> list, List<Menu> sourcelist, String parentId, boolean cascade) {
        int i = 0;
        while (i < sourcelist.size()) {
            Menu e = sourcelist.get(i);
            if (e.getParent() != null && e.getParent().getId() != null && e.getParent().getId().equals(parentId)) {
                list.add(e);
                if (cascade) {
                    int j = 0;
                    while (j < sourcelist.size()) {
                        Menu child = sourcelist.get(j);
                        if (child.getParent() != null && child.getParent().getId() != null && child.getParent().getId().equals(e.getId())) {
                            Menu.sortList(list, sourcelist, e.getId(), true);
                            break;
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    @JsonIgnore
    public static String getRootId() {
        return "1";
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public void setChildren(List<Menu> children) {
        this.children = children;
    }

    public List<Menu> getChildren() {
        return this.children;
    }
}

