/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waqf.modules.sys.service;

import com.crawler.waqf.common.config.Global;
import com.crawler.waqf.common.persistence.Page;
import com.crawler.waqf.common.security.Digests;
import com.crawler.waqf.common.security.shiro.session.SessionDAO;
import com.crawler.waqf.common.service.BaseService;
import com.crawler.waqf.common.service.ServiceException;
import com.crawler.waqf.common.utils.CacheUtils;
import com.crawler.waqf.common.utils.Encodes;
import com.crawler.waqf.common.utils.IdUtils;
import com.crawler.waqf.common.utils.StringUtils;
import com.crawler.waqf.modules.sys.dao.MenuDao;
import com.crawler.waqf.modules.sys.dao.RoleDao;
import com.crawler.waqf.modules.sys.dao.UserDao;
import com.crawler.waqf.modules.sys.entity.Menu;
import com.crawler.waqf.modules.sys.entity.Role;
import com.crawler.waqf.modules.sys.entity.User;
import com.crawler.waqf.modules.sys.security.SystemAuthorizingRealm;
import com.crawler.waqf.modules.sys.utils.UserUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.shiro.session.Session;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class SystemService
extends BaseService
implements InitializingBean {
    public static final String HASH_ALGORITHM = "SHA-1";
    public static final int HASH_INTERATIONS = 1024;
    public static final int SALT_SIZE = 8;
    @Autowired
    private UserDao userDao;
    @Autowired
    private RoleDao roleDao;
    @Autowired
    private MenuDao menuDao;
    @Autowired
    private SessionDAO sessionDao;
    @Autowired
    private SystemAuthorizingRealm systemRealm;

    public SessionDAO getSessionDao() {
        return this.sessionDao;
    }

    public User getUser(String id) {
        return UserUtils.get(id);
    }

    public User getUserByLoginName(String loginName) {
        return UserUtils.getByLoginName(loginName);
    }

    public Page<User> findUser(Page<User> page, User user) {
        user.setPage(page);
        page.setList(this.userDao.findList(user));
        return page;
    }

    public List<User> findUser(User user) {
        List<User> list = this.userDao.findList(user);
        return list;
    }

    @Transactional(readOnly=false)
    public void saveUser(User user) {
        if (IdUtils.isBlank((Serializable)((Object)user.getId()), new String[0])) {
            user.preInsert();
            this.userDao.insert(user);
        } else {
            user.preUpdate();
            this.userDao.update(user);
        }
        if (IdUtils.isNotBlank((Serializable)((Object)user.getId()), new String[0])) {
            this.userDao.deleteUserRole(user);
            if (user.getRoleList() == null || user.getRoleList().size() <= 0) {
                throw new ServiceException(String.valueOf(user.getLoginName()) + "\u6ca1\u6709\u8bbe\u7f6e\u89d2\u8272\uff01");
            }
            this.userDao.insertUserRole(user);
            UserUtils.clearCache(user);
        }
    }

    @Transactional(readOnly=false)
    public void updateUserInfo(User user) {
        user.preUpdate();
        this.userDao.updateUserInfo(user);
        UserUtils.clearCache(user);
    }

    @Transactional(readOnly=false)
    public void deleteUser(User user) {
        this.userDao.delete(user);
        UserUtils.clearCache(user);
    }

    @Transactional(readOnly=false)
    public void updatePasswordById(String id, String loginName, String newPassword) {
        User user = new User(id);
        user.setPassword(SystemService.entryptPassword(newPassword));
        this.userDao.updatePasswordById(user);
        user.setLoginName(loginName);
        UserUtils.clearCache(user);
        Collection<Session> sessions = this.sessionDao.getActiveSessions(true, UserUtils.getPrincipal(), null);
        if (sessions.size() > 0) {
            for (Session session : sessions) {
                System.out.println(session.getId());
                if (session.getId().equals(UserUtils.getSession().getId())) continue;
                this.sessionDao.delete(session);
            }
        }
    }

    @Transactional(readOnly=false)
    public void updateUserLoginInfo(User user) {
        user.setOldLoginIp(user.getLoginIp());
        user.setOldLoginDate(user.getLoginDate());
        user.setLoginIp(UserUtils.getSession().getHost());
        user.setLoginDate(new Date());
        this.userDao.updateLoginInfo(user);
    }

    public static String entryptPassword(String plainPassword) {
        byte[] salt = Digests.generateSalt(8);
        byte[] hashPassword = Digests.sha1(plainPassword.getBytes(), salt, 1024);
        return String.valueOf(Encodes.encodeHex(salt)) + Encodes.encodeHex(hashPassword);
    }

    public static boolean validatePassword(String plainPassword, String password) {
        byte[] salt = Encodes.decodeHex(password.substring(0, 16));
        byte[] hashPassword = Digests.sha1(plainPassword.getBytes(), salt, 1024);
        return password.equals(String.valueOf(Encodes.encodeHex(salt)) + Encodes.encodeHex(hashPassword));
    }

    public Collection<Session> getActiveSessions() {
        return this.sessionDao.getActiveSessions(false);
    }

    public Role getRole(String id) {
        return (Role)((Object)this.roleDao.get(id));
    }

    public Role getRoleByName(String name) {
        Role r = new Role();
        r.setName(name);
        return this.roleDao.getByName(r);
    }

    public Role getRoleByEnname(String enname) {
        Role r = new Role();
        r.setEnname(enname);
        return this.roleDao.getByEnname(r);
    }

    public List<Role> findRole(Role role) {
        return this.roleDao.findList(role);
    }

    public List<Role> findAllRole() {
        return UserUtils.getRoleList();
    }

    @Transactional(readOnly=false)
    public void saveRole(Role role) {
        if (StringUtils.isBlank((CharSequence)role.getId())) {
            role.preInsert();
            this.roleDao.insert(role);
        } else {
            role.preUpdate();
            this.roleDao.update(role);
        }
        this.roleDao.deleteRoleMenu(role);
        if (role.getMenuList().size() > 0) {
            this.roleDao.insertRoleMenu(role);
        }
        UserUtils.removeCache("roleList");
    }

    @Transactional(readOnly=false)
    public void deleteRole(Role role) {
        this.roleDao.delete(role);
        UserUtils.removeCache("roleList");
    }

    @Transactional(readOnly=false)
    public Boolean outUserInRole(Role role, User user) {
        List<Role> roles = user.getRoleList();
        for (Role e : roles) {
            if (!e.getId().equals(role.getId())) continue;
            roles.remove(e);
            this.saveUser(user);
            return true;
        }
        return false;
    }

    @Transactional(readOnly=false)
    public User assignUserToRole(Role role, User user) {
        if (user == null) {
            return null;
        }
        List<String> roleIds = user.getRoleIdList();
        if (roleIds.contains(role.getId())) {
            return null;
        }
        user.getRoleList().add(role);
        this.saveUser(user);
        return user;
    }

    public Menu getMenu(String id) {
        return (Menu)((Object)this.menuDao.get(id));
    }

    public List<Menu> findAllMenu() {
        return UserUtils.getMenuList();
    }

    @Transactional(readOnly=false)
    public void saveMenu(Menu menu) {
        menu.setParent(this.getMenu(menu.getParent().getId()));
        String oldParentIds = menu.getParentIds();
        menu.setParentIds(String.valueOf(menu.getParent().getParentIds()) + menu.getParent().getId() + ",");
        if (StringUtils.isBlank((CharSequence)menu.getId())) {
            menu.preInsert();
            this.menuDao.insert(menu);
        } else {
            menu.preUpdate();
            this.menuDao.update(menu);
        }
        Menu m = new Menu();
        m.setParentIds("%," + menu.getId() + ",%");
        List<Menu> list = this.menuDao.findByParentIdsLike(m);
        for (Menu e : list) {
            e.setParentIds(e.getParentIds().replace(oldParentIds, menu.getParentIds()));
            this.menuDao.updateParentIds(e);
        }
        UserUtils.removeCache("menuList");
        CacheUtils.remove("menuNamePathMap");
    }

    @Transactional(readOnly=false)
    public void updateMenuSort(Menu menu) {
        this.menuDao.updateSort(menu);
        UserUtils.removeCache("menuList");
        CacheUtils.remove("menuNamePathMap");
    }

    @Transactional(readOnly=false)
    public void deleteMenu(Menu menu) {
        this.menuDao.delete(menu);
        UserUtils.removeCache("menuList");
        CacheUtils.remove("menuNamePathMap");
    }

    public static boolean printKeyLoadMessage() {
        StringBuilder sb = new StringBuilder();
        String appName = Global.getConfig("productName");
        if (appName == null || "".equals(appName)) {
            appName = Global.getConfig("appName");
        }
        sb.append("\r\n======================================================================\r\n");
        sb.append("\r\n  " + appName + " - \u521d\u59cb\u5316  \r\n");
        sb.append("\r\n======================================================================\r\n");
        System.out.println(sb.toString());
        return true;
    }

    public void afterPropertiesSet() throws Exception {
    }
}

