/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waqf.modules.sys.utils;

import com.crawler.waqf.common.config.Global;
import com.crawler.waqf.common.utils.CacheUtils;
import com.crawler.waqf.common.utils.Exceptions;
import com.crawler.waqf.common.utils.SpringContextHolder;
import com.crawler.waqf.common.utils.StringUtils;
import com.crawler.waqf.modules.sys.dao.LogDao;
import com.crawler.waqf.modules.sys.dao.MenuDao;
import com.crawler.waqf.modules.sys.entity.Log;
import com.crawler.waqf.modules.sys.entity.Menu;
import com.crawler.waqf.modules.sys.entity.User;
import com.crawler.waqf.modules.sys.utils.UserUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.method.HandlerMethod;

public class LogUtils {
    public static final String CACHE_MENU_NAME_PATH_MAP = "menuNamePathMap";
    private static LogDao logDao = SpringContextHolder.getBean(LogDao.class);
    private static MenuDao menuDao = SpringContextHolder.getBean(MenuDao.class);

    public static void saveLog(HttpServletRequest request, String title) {
        LogUtils.saveLog(request, null, null, title);
    }

    public static void saveLog(HttpServletRequest request, Object handler, Exception ex, String title) {
        User user = UserUtils.getUser();
        if (user != null && user.getId() != null) {
            Log log = new Log();
            log.setTitle(title);
            log.setType(ex == null ? "1" : "2");
            log.setRemoteAddr(StringUtils.getRemoteAddr(request));
            log.setUserAgent(request.getHeader("user-agent"));
            log.setRequestUri(request.getRequestURI());
            log.setParams(request.getParameterMap());
            log.setMethod(request.getMethod());
            new SaveLogThread(log, handler, ex).start();
        }
    }

    public static String getMenuNamePath(String requestUri, String permission) {
        String menuNamePath;
        String href = StringUtils.substringAfter((String)requestUri, (String)Global.getAdminPath());
        Map menuMap = (Map)CacheUtils.get(CACHE_MENU_NAME_PATH_MAP);
        if (menuMap == null) {
            menuMap = Maps.newHashMap();
            List<Menu> menuList = menuDao.findAllList(new Menu());
            for (Menu menu : menuList) {
                int n;
                String namePath = "";
                if (menu.getParentIds() != null) {
                    ArrayList namePathList = Lists.newArrayList();
                    String[] stringArray = StringUtils.split((String)menu.getParentIds(), (String)",");
                    int n2 = stringArray.length;
                    n = 0;
                    while (n < n2) {
                        String id = stringArray[n];
                        if (!Menu.getRootId().equals(id)) {
                            for (Menu m : menuList) {
                                if (!m.getId().equals(id)) continue;
                                namePathList.add(m.getName());
                                break;
                            }
                        }
                        ++n;
                    }
                    namePathList.add(menu.getName());
                    namePath = StringUtils.join((Iterable)namePathList, (String)"-");
                }
                if (StringUtils.isNotBlank((CharSequence)menu.getHref())) {
                    menuMap.put(menu.getHref(), namePath);
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)menu.getPermission())) continue;
                String[] stringArray = StringUtils.split((String)menu.getPermission());
                n = stringArray.length;
                int n3 = 0;
                while (n3 < n) {
                    String p = stringArray[n3];
                    menuMap.put(p, namePath);
                    ++n3;
                }
            }
            CacheUtils.put(CACHE_MENU_NAME_PATH_MAP, menuMap);
        }
        if ((menuNamePath = (String)menuMap.get(href)) == null) {
            String[] stringArray = StringUtils.split((String)permission);
            int n = stringArray.length;
            int n4 = 0;
            while (n4 < n) {
                String p = stringArray[n4];
                menuNamePath = (String)menuMap.get(p);
                if (StringUtils.isNotBlank((CharSequence)menuNamePath)) break;
                ++n4;
            }
            if (menuNamePath == null) {
                return "";
            }
        }
        return menuNamePath;
    }

    public static class SaveLogThread
    extends Thread {
        private Log log;
        private Object handler;
        private Exception ex;

        public SaveLogThread(Log log, Object handler, Exception ex) {
            super(SaveLogThread.class.getSimpleName());
            this.log = log;
            this.handler = handler;
            this.ex = ex;
        }

        @Override
        public void run() {
            if (StringUtils.isBlank((CharSequence)this.log.getTitle())) {
                String permission = "";
                if (this.handler instanceof HandlerMethod) {
                    Method m = ((HandlerMethod)this.handler).getMethod();
                    RequiresPermissions rp = m.getAnnotation(RequiresPermissions.class);
                    permission = rp != null ? StringUtils.join((Object[])rp.value(), (String)",") : "";
                }
                this.log.setTitle(LogUtils.getMenuNamePath(this.log.getRequestUri(), permission));
            }
            this.log.setException(Exceptions.getStackTraceAsString(this.ex));
            if (StringUtils.isBlank((CharSequence)this.log.getTitle()) && StringUtils.isBlank((CharSequence)this.log.getException())) {
                return;
            }
            this.log.preInsert();
            logDao.insert(this.log);
        }
    }
}

