/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waqf.modules.sys.web;

import com.crawler.waqf.common.utils.StringUtils;
import com.crawler.waqf.common.web.BaseController;
import com.crawler.waqf.modules.sys.entity.Area;
import com.crawler.waqf.modules.sys.service.AreaService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"${adminPath}/sys/area"})
public class AreaController
extends BaseController {
    @Autowired
    private AreaService areaService;

    @ModelAttribute(value="area")
    public Area get(@RequestParam(required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            return (Area)((Object)this.areaService.get(id));
        }
        return new Area();
    }

    @RequiresPermissions(value={"sys:area:list"})
    @RequestMapping(value={"list", ""})
    public String list(Area area, Model model) {
        model.addAttribute("list", this.areaService.findAll());
        return "modules/sys/areaList";
    }

    @RequiresPermissions(value={"sys:area:view", "sys:area:add", "sys:area:edit"}, logical=Logical.OR)
    @RequestMapping(value={"form"})
    public String form(Area area, Model model) {
        if (area.getParent() == null || area.getParent().getId() == null) {
            area.setParent(null);
        } else {
            area.setParent((Area)((Object)this.areaService.get(area.getParent().getId())));
        }
        model.addAttribute("area", (Object)area);
        return "modules/sys/areaForm";
    }

    @RequiresPermissions(value={"sys:area:add", "sys:area:edit"}, logical=Logical.OR)
    @RequestMapping(value={"save"})
    public String save(Area area, Model model, RedirectAttributes redirectAttributes) {
        if (!this.beanValidator(model, (Object)area, new Class[0])) {
            return this.form(area, model);
        }
        this.areaService.save(area);
        this.addMessage(redirectAttributes, "\u4fdd\u5b58\u533a\u57df'" + area.getName() + "'\u6210\u529f");
        return "redirect:" + this.adminPath + "/sys/area/";
    }

    @RequiresPermissions(value={"sys:area:del"})
    @RequestMapping(value={"delete"})
    public String delete(Area area, RedirectAttributes redirectAttributes) {
        this.areaService.delete(area);
        this.addMessage(redirectAttributes, "\u5220\u9664\u533a\u57df\u6210\u529f");
        return "redirect:" + this.adminPath + "/sys/area/";
    }

    @RequiresPermissions(value={"user"})
    @ResponseBody
    @RequestMapping(value={"treeData"})
    public List<Map<String, Object>> treeData(@RequestParam(required=false) String extId, HttpServletResponse response) {
        ArrayList mapList = Lists.newArrayList();
        List<Area> list = this.areaService.findAll();
        int i = 0;
        while (i < list.size()) {
            Area e = list.get(i);
            if (StringUtils.isBlank((CharSequence)extId) || extId != null && !extId.equals(e.getId()) && e.getParentIds().indexOf("," + extId + ",") == -1) {
                HashMap map = Maps.newHashMap();
                map.put("id", e.getId());
                map.put("pId", e.getParentId());
                map.put("name", e.getName());
                mapList.add(map);
            }
            ++i;
        }
        return mapList;
    }
}

