/*
 * Decompiled with CFR 0.152.
 */
package com.crawler.waqf.modules.sys.web;

import com.crawler.waqf.common.beanvalidator.BeanValidators;
import com.crawler.waqf.common.config.Global;
import com.crawler.waqf.common.json.AjaxJson;
import com.crawler.waqf.common.persistence.Page;
import com.crawler.waqf.common.utils.DateUtils;
import com.crawler.waqf.common.utils.StringUtils;
import com.crawler.waqf.common.utils.excel.ExportExcel;
import com.crawler.waqf.common.utils.excel.ImportExcel;
import com.crawler.waqf.common.web.BaseController;
import com.crawler.waqf.modules.sys.dao.UserDao;
import com.crawler.waqf.modules.sys.entity.Role;
import com.crawler.waqf.modules.sys.entity.User;
import com.crawler.waqf.modules.sys.service.SystemService;
import com.crawler.waqf.modules.sys.utils.UserUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolationException;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"${adminPath}/sys/user"})
public class UserController
extends BaseController {
    @Autowired
    private SystemService systemService;
    @Autowired
    private UserDao userDao;

    @ModelAttribute
    public User get(@RequestParam(required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            return this.systemService.getUser(id);
        }
        return new User();
    }

    @RequiresPermissions(value={"sys:user:index"})
    @RequestMapping(value={"index", "list", ""})
    public String index(User user, HttpServletRequest request, HttpServletResponse response, Model model) {
        Page<User> page = this.systemService.findUser(new Page<User>(request, response), user);
        model.addAttribute("page", page);
        return "modules/sys/userIndex";
    }

    @RequiresPermissions(value={"sys:user:view", "sys:user:add", "sys:user:edit"}, logical=Logical.OR)
    @RequestMapping(value={"form"})
    public String form(User user, Model model) {
        model.addAttribute("user", (Object)user);
        model.addAttribute("allRoles", this.systemService.findAllRole());
        return "modules/sys/userForm";
    }

    @RequiresPermissions(value={"sys:user:add", "sys:user:edit"}, logical=Logical.OR)
    @RequestMapping(value={"save"})
    public String save(User user, HttpServletRequest request, Model model, RedirectAttributes redirectAttributes) {
        if (StringUtils.isNotBlank((CharSequence)user.getNewPassword())) {
            user.setPassword(SystemService.entryptPassword(user.getNewPassword()));
        }
        if (!this.beanValidator(model, (Object)user, new Class[0])) {
            return this.form(user, model);
        }
        if (!"true".equals(this.checkLoginName(user.getOldLoginName(), user.getLoginName()))) {
            this.addMessage(model, "\u4fdd\u5b58\u7528\u6237'" + user.getLoginName() + "'\u5931\u8d25\uff0c\u767b\u5f55\u540d\u5df2\u5b58\u5728");
            return this.form(user, model);
        }
        ArrayList roleList = Lists.newArrayList();
        List<String> roleIdList = user.getRoleIdList();
        for (Role r : this.systemService.findAllRole()) {
            if (!roleIdList.contains(r.getId())) continue;
            roleList.add(r);
        }
        user.setRoleList(roleList);
        if (StringUtils.isBlank((CharSequence)user.getAvatar())) {
            user.setAvatar(Global.getDefaultAvatar());
        }
        this.systemService.saveUser(user);
        if (user.getLoginName().equals(UserUtils.getUser().getLoginName())) {
            UserUtils.clearCache();
        }
        this.addMessage(redirectAttributes, "\u4fdd\u5b58\u7528\u6237'" + user.getLoginName() + "'\u6210\u529f");
        return "redirect:" + this.adminPath + "/sys/user/list?repage";
    }

    @RequiresPermissions(value={"sys:user:del"})
    @RequestMapping(value={"delete"})
    public String delete(User user, RedirectAttributes redirectAttributes) {
        if (UserUtils.getUser().getId().equals(user.getId())) {
            this.addMessage(redirectAttributes, "\u5220\u9664\u7528\u6237\u5931\u8d25, \u4e0d\u5141\u8bb8\u5220\u9664\u5f53\u524d\u7528\u6237");
        } else if (User.isAdmin(user.getId())) {
            this.addMessage(redirectAttributes, "\u5220\u9664\u7528\u6237\u5931\u8d25, \u4e0d\u5141\u8bb8\u5220\u9664\u8d85\u7ea7\u7ba1\u7406\u5458\u7528\u6237");
        } else {
            this.systemService.deleteUser(user);
            this.addMessage(redirectAttributes, "\u5220\u9664\u7528\u6237\u6210\u529f");
        }
        return "redirect:" + this.adminPath + "/sys/user/list?repage";
    }

    @RequiresPermissions(value={"sys:user:del"})
    @RequestMapping(value={"deleteAll"})
    public String deleteAll(String ids, RedirectAttributes redirectAttributes) {
        String[] idArray;
        String[] stringArray = idArray = ids.split(",");
        int n = idArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            User user = this.systemService.getUser(id);
            if (UserUtils.getUser().getId().equals(user.getId())) {
                this.addMessage(redirectAttributes, "\u5220\u9664\u7528\u6237\u5931\u8d25, \u4e0d\u5141\u8bb8\u5220\u9664\u5f53\u524d\u7528\u6237");
            } else if (User.isAdmin(user.getId())) {
                this.addMessage(redirectAttributes, "\u5220\u9664\u7528\u6237\u5931\u8d25, \u4e0d\u5141\u8bb8\u5220\u9664\u8d85\u7ea7\u7ba1\u7406\u5458\u7528\u6237");
            } else {
                this.systemService.deleteUser(user);
                this.addMessage(redirectAttributes, "\u5220\u9664\u7528\u6237\u6210\u529f");
            }
            ++n2;
        }
        return "redirect:" + this.adminPath + "/sys/user/list?repage";
    }

    @RequiresPermissions(value={"sys:user:export"})
    @RequestMapping(value={"export"}, method={RequestMethod.POST})
    public String exportFile(User user, HttpServletRequest request, HttpServletResponse response, RedirectAttributes redirectAttributes) {
        try {
            String fileName = "\u7528\u6237\u6570\u636e" + DateUtils.getDate("yyyyMMddHHmmss") + ".xlsx";
            Page<User> page = this.systemService.findUser(new Page<User>(request, response, -1), user);
            new ExportExcel("\u7528\u6237\u6570\u636e", User.class).setDataList(page.getList()).write(response, fileName).dispose();
            return null;
        }
        catch (Exception e) {
            this.addMessage(redirectAttributes, "\u5bfc\u51fa\u7528\u6237\u5931\u8d25\uff01\u5931\u8d25\u4fe1\u606f\uff1a" + e.getMessage());
            return "redirect:" + this.adminPath + "/sys/user/list?repage";
        }
    }

    /*
     * Unable to fully structure code
     */
    @RequiresPermissions(value={"sys:user:import"})
    @RequestMapping(value={"import"}, method={RequestMethod.POST})
    public String importFile(MultipartFile file, RedirectAttributes redirectAttributes) {
        try {
            successNum = 0;
            failureNum = 0;
            failureMsg = new StringBuilder();
            ei = new ImportExcel(file, 1, 0);
            list = ei.getDataList(User.class, new int[0]);
            block5: for (User user : list) {
                try {
                    if ("true".equals(this.checkLoginName("", user.getLoginName()))) {
                        user.setPassword(SystemService.entryptPassword("123456"));
                        BeanValidators.validateWithException(this.validator, user, new Class[0]);
                        this.systemService.saveUser(user);
                        ++successNum;
                        continue;
                    }
                    failureMsg.append("<br/>\u767b\u5f55\u540d " + user.getLoginName() + " \u5df2\u5b58\u5728; ");
                    ++failureNum;
                    continue;
                }
                catch (ConstraintViolationException ex) {
                    failureMsg.append("<br/>\u767b\u5f55\u540d " + user.getLoginName() + " \u5bfc\u5165\u5931\u8d25\uff1a");
                    messageList = BeanValidators.extractPropertyAndMessageAsList(ex, ": ");
                    ** for (message : messageList)
                }
lbl-1000:
                // 1 sources

                {
                    failureMsg.append(String.valueOf(message) + "; ");
                    ++failureNum;
                    continue;
lbl28:
                    // 1 sources

                    continue block5;
                }
                catch (Exception ex) {
                    failureMsg.append("<br/>\u767b\u5f55\u540d " + user.getLoginName() + " \u5bfc\u5165\u5931\u8d25\uff1a" + ex.getMessage());
                }
            }
            if (failureNum > 0) {
                failureMsg.insert(0, "\uff0c\u5931\u8d25 " + failureNum + " \u6761\u7528\u6237\uff0c\u5bfc\u5165\u4fe1\u606f\u5982\u4e0b\uff1a");
            }
            this.addMessage(redirectAttributes, new String[]{"\u5df2\u6210\u529f\u5bfc\u5165 " + successNum + " \u6761\u7528\u6237" + failureMsg});
        }
        catch (Exception e) {
            this.addMessage(redirectAttributes, new String[]{"\u5bfc\u5165\u7528\u6237\u5931\u8d25\uff01\u5931\u8d25\u4fe1\u606f\uff1a" + e.getMessage()});
        }
        return "redirect:" + this.adminPath + "/sys/user/list?repage";
    }

    @RequiresPermissions(value={"sys:user:import"})
    @RequestMapping(value={"import/template"})
    public String importFileTemplate(HttpServletResponse response, RedirectAttributes redirectAttributes) {
        try {
            String fileName = "\u7528\u6237\u6570\u636e\u5bfc\u5165\u6a21\u677f.xlsx";
            ArrayList list = Lists.newArrayList();
            list.add(UserUtils.getUser());
            new ExportExcel("\u7528\u6237\u6570\u636e", User.class, 2, new int[0]).setDataList(list).write(response, fileName).dispose();
            return null;
        }
        catch (Exception e) {
            this.addMessage(redirectAttributes, "\u5bfc\u5165\u6a21\u677f\u4e0b\u8f7d\u5931\u8d25\uff01\u5931\u8d25\u4fe1\u606f\uff1a" + e.getMessage());
            return "redirect:" + this.adminPath + "/sys/user/list?repage";
        }
    }

    @ResponseBody
    @RequiresPermissions(value={"sys:user:add", "sys:user:edit"}, logical=Logical.OR)
    @RequestMapping(value={"checkLoginName"})
    public String checkLoginName(String oldLoginName, String loginName) {
        if (loginName != null && loginName.equals(oldLoginName)) {
            return "true";
        }
        if (loginName != null && this.systemService.getUserByLoginName(loginName) == null) {
            return "true";
        }
        return "false";
    }

    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"info"})
    public String info(HttpServletResponse response, Model model) {
        User currentUser = UserUtils.getUser();
        model.addAttribute("user", (Object)currentUser);
        model.addAttribute("Global", (Object)new Global());
        return "modules/sys/userInfo";
    }

    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"infoEdit"})
    public String infoEdit(User user, boolean __ajax, HttpServletResponse response, Model model) {
        User currentUser = UserUtils.getUser();
        if (StringUtils.isNotBlank((CharSequence)user.getName())) {
            if (user.getName() != null) {
                currentUser.setName(user.getName());
            }
            if (user.getEmail() != null) {
                currentUser.setEmail(user.getEmail());
            }
            if (user.getPhone() != null) {
                currentUser.setPhone(user.getPhone());
            }
            this.systemService.updateUserInfo(currentUser);
            if (__ajax) {
                AjaxJson j = new AjaxJson();
                j.setSuccess(true);
                j.setMsg("\u4fee\u6539\u4e2a\u4eba\u8d44\u6599\u6210\u529f!");
                return this.renderString(response, j);
            }
            model.addAttribute("user", (Object)currentUser);
            model.addAttribute("Global", (Object)new Global());
            model.addAttribute("message", (Object)"\u4fdd\u5b58\u7528\u6237\u4fe1\u606f\u6210\u529f");
            return "modules/sys/userInfo";
        }
        model.addAttribute("user", (Object)currentUser);
        model.addAttribute("Global", (Object)new Global());
        return "modules/sys/userInfoEdit";
    }

    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"imageEdit"})
    public String imageEdit(User user, boolean __ajax, HttpServletResponse response, Model model) {
        User currentUser = UserUtils.getUser();
        if (StringUtils.isNotBlank((CharSequence)user.getName())) {
            if (user.getAvatar() != null) {
                currentUser.setAvatar(user.getAvatar());
            }
            this.systemService.updateUserInfo(currentUser);
            if (__ajax) {
                AjaxJson j = new AjaxJson();
                j.setSuccess(true);
                j.setMsg("\u4fee\u6539\u4e2a\u4eba\u5934\u50cf\u6210\u529f!");
                return this.renderString(response, j);
            }
            model.addAttribute("message", (Object)"\u4fdd\u5b58\u7528\u6237\u4fe1\u606f\u6210\u529f");
            return "modules/sys/userInfo";
        }
        model.addAttribute("user", (Object)currentUser);
        model.addAttribute("Global", (Object)new Global());
        return "modules/sys/userImageEdit";
    }

    @RequiresPermissions(value={"user"})
    @ResponseBody
    @RequestMapping(value={"infoData"})
    public AjaxJson infoData() {
        AjaxJson j = new AjaxJson();
        j.setSuccess(true);
        j.setErrorCode("-1");
        j.setMsg("\u83b7\u53d6\u4e2a\u4eba\u4fe1\u606f\u6210\u529f!");
        j.put("data", UserUtils.getUser());
        return j;
    }

    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"modifyPwd"}, method={RequestMethod.GET})
    public String modifyPwd(String oldPassword, String newPassword, Model model) {
        User user = UserUtils.getUser();
        model.addAttribute("user", (Object)user);
        return "modules/sys/userModifyPwd";
    }

    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"modifyPwd"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson modifyPwd(String oldPassword, String newPassword) {
        AjaxJson ajaxJson = new AjaxJson();
        User user = UserUtils.getUser();
        if (StringUtils.isNotBlank((CharSequence)oldPassword) && StringUtils.isNotBlank((CharSequence)newPassword)) {
            if (SystemService.validatePassword(oldPassword, user.getPassword())) {
                this.systemService.updatePasswordById(user.getId(), user.getLoginName(), newPassword);
                ajaxJson.setSuccess(true);
                ajaxJson.setMsg("\u4fee\u6539\u5bc6\u7801\u6210\u529f");
            } else {
                ajaxJson.setSuccess(false);
                ajaxJson.setMsg("\u4fee\u6539\u5bc6\u7801\u5931\u8d25\uff0c\u65e7\u5bc6\u7801\u9519\u8bef");
            }
        } else {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u65e7\u5bc6\u7801\u6216\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return ajaxJson;
    }

    @ResponseBody
    @RequestMapping(value={"validateLoginName"})
    public boolean validateLoginName(String loginName, HttpServletResponse response) {
        User user = (User)this.userDao.findUniqueByProperty("login_name", loginName);
        return user == null;
    }

    @ResponseBody
    @RequestMapping(value={"validateMobile"})
    public boolean validateMobile(String mobile, HttpServletResponse response, Model model) {
        User user = (User)this.userDao.findUniqueByProperty("mobile", mobile);
        return user == null;
    }

    @ResponseBody
    @RequestMapping(value={"validateMobileExist"})
    public boolean validateMobileExist(String mobile, HttpServletResponse response, Model model) {
        User user = (User)this.userDao.findUniqueByProperty("mobile", mobile);
        return user != null;
    }
}

