/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.spring;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.builder.xml.XMLConfigBuilder;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.thread.Runnable;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.type.TypeHandler;
import org.mybatis.spring.transaction.SpringManagedTransactionFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.NestedIOException;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class SqlSessionFactoryBean
implements FactoryBean<SqlSessionFactory>,
InitializingBean,
ApplicationListener<ApplicationEvent> {
    private static final Log logger = LogFactory.getLog(SqlSessionFactoryBean.class);
    private Resource configLocation;
    private Resource[] mapperLocations;
    private DataSource dataSource;
    private TransactionFactory transactionFactory;
    private Properties configurationProperties;
    private SqlSessionFactoryBuilder sqlSessionFactoryBuilder = new SqlSessionFactoryBuilder();
    private SqlSessionFactory sqlSessionFactory;
    private String environment = SqlSessionFactoryBean.class.getSimpleName();
    private boolean failFast;
    private Interceptor[] plugins;
    private TypeHandler<?>[] typeHandlers;
    private String typeHandlersPackage;
    private Class<?>[] typeAliases;
    private String typeAliasesPackage;
    private Class<?> typeAliasesSuperType;
    private DatabaseIdProvider databaseIdProvider;
    private ObjectFactory objectFactory;
    private ObjectWrapperFactory objectWrapperFactory;

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public void setObjectWrapperFactory(ObjectWrapperFactory objectWrapperFactory) {
        this.objectWrapperFactory = objectWrapperFactory;
    }

    public DatabaseIdProvider getDatabaseIdProvider() {
        return this.databaseIdProvider;
    }

    public void setDatabaseIdProvider(DatabaseIdProvider databaseIdProvider) {
        this.databaseIdProvider = databaseIdProvider;
    }

    public void setPlugins(Interceptor[] plugins) {
        this.plugins = plugins;
    }

    public void setTypeAliasesPackage(String typeAliasesPackage) {
        this.typeAliasesPackage = typeAliasesPackage;
    }

    public void setTypeAliasesSuperType(Class<?> typeAliasesSuperType) {
        this.typeAliasesSuperType = typeAliasesSuperType;
    }

    public void setTypeHandlersPackage(String typeHandlersPackage) {
        this.typeHandlersPackage = typeHandlersPackage;
    }

    public void setTypeHandlers(TypeHandler<?>[] typeHandlers) {
        this.typeHandlers = typeHandlers;
    }

    public void setTypeAliases(Class<?>[] typeAliases) {
        this.typeAliases = typeAliases;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setMapperLocations(Resource[] mapperLocations) {
        this.mapperLocations = mapperLocations;
    }

    public void setConfigurationProperties(Properties sqlSessionFactoryProperties) {
        this.configurationProperties = sqlSessionFactoryProperties;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource instanceof TransactionAwareDataSourceProxy ? ((TransactionAwareDataSourceProxy)dataSource).getTargetDataSource() : dataSource;
    }

    public void setSqlSessionFactoryBuilder(SqlSessionFactoryBuilder sqlSessionFactoryBuilder) {
        this.sqlSessionFactoryBuilder = sqlSessionFactoryBuilder;
    }

    public void setTransactionFactory(TransactionFactory transactionFactory) {
        this.transactionFactory = transactionFactory;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.dataSource, (String)"Property 'dataSource' is required");
        Assert.notNull((Object)this.sqlSessionFactoryBuilder, (String)"Property 'sqlSessionFactoryBuilder' is required");
        this.sqlSessionFactory = this.buildSqlSessionFactory();
    }

    protected SqlSessionFactory buildSqlSessionFactory() throws IOException {
        String packageToScan2;
        int n;
        int n2;
        String[] stringArray;
        Configuration configuration;
        XMLConfigBuilder xmlConfigBuilder = null;
        if (this.configLocation != null) {
            xmlConfigBuilder = new XMLConfigBuilder(this.configLocation.getInputStream(), null, this.configurationProperties);
            configuration = xmlConfigBuilder.getConfiguration();
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Property 'configLocation' not specified, using default MyBatis Configuration");
            }
            configuration = new Configuration();
            configuration.setVariables(this.configurationProperties);
        }
        if (this.objectFactory != null) {
            configuration.setObjectFactory(this.objectFactory);
        }
        if (this.objectWrapperFactory != null) {
            configuration.setObjectWrapperFactory(this.objectWrapperFactory);
        }
        if (StringUtils.hasLength((String)this.typeAliasesPackage)) {
            String[] typeAliasPackageArray;
            stringArray = typeAliasPackageArray = StringUtils.tokenizeToStringArray((String)this.typeAliasesPackage, (String)",; \t\n");
            n2 = typeAliasPackageArray.length;
            n = 0;
            while (n < n2) {
                packageToScan2 = stringArray[n];
                configuration.getTypeAliasRegistry().registerAliases(packageToScan2, this.typeAliasesSuperType == null ? Object.class : this.typeAliasesSuperType);
                if (logger.isDebugEnabled()) {
                    logger.debug("Scanned package: '" + packageToScan2 + "' for aliases");
                }
                ++n;
            }
        }
        if (!ObjectUtils.isEmpty((Object[])this.typeAliases)) {
            Class<?>[] classArray = this.typeAliases;
            n = this.typeAliases.length;
            int packageToScan2 = 0;
            while (packageToScan2 < n) {
                Class<?> typeAlias = classArray[packageToScan2];
                configuration.getTypeAliasRegistry().registerAlias(typeAlias);
                if (logger.isDebugEnabled()) {
                    logger.debug("Registered type alias: '" + typeAlias + "'");
                }
                ++packageToScan2;
            }
        }
        if (!ObjectUtils.isEmpty((Object[])this.plugins)) {
            Interceptor[] interceptorArray = this.plugins;
            n = this.plugins.length;
            int packageToScan2 = 0;
            while (packageToScan2 < n) {
                Interceptor plugin = interceptorArray[packageToScan2];
                configuration.addInterceptor(plugin);
                if (logger.isDebugEnabled()) {
                    logger.debug("Registered plugin: '" + plugin + "'");
                }
                ++packageToScan2;
            }
        }
        if (StringUtils.hasLength((String)this.typeHandlersPackage)) {
            String[] typeHandlersPackageArray;
            stringArray = typeHandlersPackageArray = StringUtils.tokenizeToStringArray((String)this.typeHandlersPackage, (String)",; \t\n");
            n2 = typeHandlersPackageArray.length;
            n = 0;
            while (n < n2) {
                packageToScan2 = stringArray[n];
                configuration.getTypeHandlerRegistry().register(packageToScan2);
                if (logger.isDebugEnabled()) {
                    logger.debug("Scanned package: '" + packageToScan2 + "' for type handlers");
                }
                ++n;
            }
        }
        if (!ObjectUtils.isEmpty((Object[])this.typeHandlers)) {
            TypeHandler<?>[] typeHandlerArray = this.typeHandlers;
            n = this.typeHandlers.length;
            int packageToScan3 = 0;
            while (packageToScan3 < n) {
                TypeHandler<?> typeHandler = typeHandlerArray[packageToScan3];
                configuration.getTypeHandlerRegistry().register(typeHandler);
                if (logger.isDebugEnabled()) {
                    logger.debug("Registered type handler: '" + typeHandler + "'");
                }
                ++packageToScan3;
            }
        }
        if (xmlConfigBuilder != null) {
            try {
                try {
                    xmlConfigBuilder.parse();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Parsed configuration file: '" + this.configLocation + "'");
                    }
                }
                catch (Exception ex) {
                    throw new NestedIOException("Failed to parse config resource: " + this.configLocation, (Throwable)ex);
                }
            }
            finally {
                ErrorContext.instance().reset();
            }
        }
        if (this.transactionFactory == null) {
            this.transactionFactory = new SpringManagedTransactionFactory();
        }
        Environment environment = new Environment(this.environment, this.transactionFactory, this.dataSource);
        configuration.setEnvironment(environment);
        if (this.databaseIdProvider != null) {
            try {
                configuration.setDatabaseId(this.databaseIdProvider.getDatabaseId(this.dataSource));
            }
            catch (SQLException e) {
                throw new NestedIOException("Failed getting a databaseId", (Throwable)e);
            }
        }
        String location = null;
        if (!ObjectUtils.isEmpty((Object[])this.mapperLocations)) {
            Resource[] resourceArray = this.mapperLocations;
            int n3 = this.mapperLocations.length;
            int n4 = 0;
            while (n4 < n3) {
                Resource mapperLocation = resourceArray[n4];
                if (location == null) {
                    location = mapperLocation.toString();
                }
                if (mapperLocation != null) {
                    try {
                        try {
                            XMLMapperBuilder xmlMapperBuilder = new XMLMapperBuilder(mapperLocation.getInputStream(), configuration, mapperLocation.toString(), configuration.getSqlFragments());
                            xmlMapperBuilder.parse();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new NestedIOException("Failed to parse mapping resource: '" + mapperLocation + "'", (Throwable)e);
                        }
                    }
                    finally {
                        ErrorContext.instance().reset();
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Parsed mapper file: '" + mapperLocation + "'");
                    }
                }
                ++n4;
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("Property 'mapperLocations' was not specified or no matching resources found");
        }
        new Runnable(location, configuration).run();
        return this.sqlSessionFactoryBuilder.build(configuration);
    }

    public SqlSessionFactory getObject() throws Exception {
        if (this.sqlSessionFactory == null) {
            this.afterPropertiesSet();
        }
        return this.sqlSessionFactory;
    }

    public Class<? extends SqlSessionFactory> getObjectType() {
        return this.sqlSessionFactory == null ? SqlSessionFactory.class : this.sqlSessionFactory.getClass();
    }

    public boolean isSingleton() {
        return true;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (this.failFast && event instanceof ContextRefreshedEvent) {
            this.sqlSessionFactory.getConfiguration().getMappedStatementNames();
        }
    }

    public static void refresh(InputStream inputStream, String resource, Configuration configuration) throws NestedIOException {
        try {
            try {
                XMLMapperBuilder xmlMapperBuilder = new XMLMapperBuilder(inputStream, configuration, resource, configuration.getSqlFragments());
                xmlMapperBuilder.parse1();
            }
            catch (Exception e) {
                throw new NestedIOException("Failed to parse mapping resource: '" + resource + "'", (Throwable)e);
            }
        }
        finally {
            ErrorContext.instance().reset();
        }
    }
}

