/*
 * Decompiled with CFR 0.152.
 */
package com.dev.base.mail.service.impl;

import com.dev.base.mail.common.MailCfg;
import com.dev.base.mail.entity.MailAttach;
import com.dev.base.mail.entity.MailMsg;
import com.dev.base.mail.service.MailService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.SimpleEmail;

public class ApacheMailServiceImpl
implements MailService {
    @Override
    public void sendMail(String toEmail, MailMsg mailMsg) {
        this.sendMail(MailCfg.DEFAULT_FROM_EMAIL, MailCfg.DEFAULT_FROM_PASSWD, MailCfg.DEFAULT_FROM_NAME, MailCfg.HOST, toEmail, mailMsg);
    }

    @Override
    public void sendMail(List<String> toEmailList, MailMsg mailMsg) {
        this.sendMail(MailCfg.DEFAULT_FROM_EMAIL, MailCfg.DEFAULT_FROM_PASSWD, MailCfg.DEFAULT_FROM_NAME, MailCfg.HOST, toEmailList, mailMsg);
    }

    @Override
    public void sendMail(String fromEmail, String fromPasswd, String fromName, String host, String toEmail, MailMsg mailMsg) {
        ArrayList<String> toEmailList = new ArrayList<String>();
        toEmailList.add(toEmail);
        this.sendMail(fromEmail, fromPasswd, fromName, host, toEmailList, mailMsg);
    }

    @Override
    public void sendMail(String fromEmail, String fromPasswd, String fromName, String host, List<String> toEmailList, MailMsg mailMsg) {
        switch (mailMsg.getType()) {
            case text: {
                this.sendTextMail(fromEmail, fromPasswd, fromName, host, toEmailList, mailMsg);
                break;
            }
            case html: {
                this.sendHtmlMail(fromEmail, fromPasswd, fromName, host, toEmailList, mailMsg);
                break;
            }
            case multi: {
                this.sendMultiMail(fromEmail, fromPasswd, fromName, host, toEmailList, mailMsg);
                break;
            }
        }
    }

    private void sendTextMail(String fromEmail, String fromPasswd, String fromName, String host, List<String> toEmailList, MailMsg mailMsg) {
        SimpleEmail email = new SimpleEmail();
        try {
            this.initEmail((Email)email, fromEmail, fromPasswd, fromName, host, toEmailList, mailMsg);
            email.setMsg(mailMsg.getContent());
            email.send();
        }
        catch (EmailException e) {
            e.printStackTrace();
        }
    }

    private void sendHtmlMail(String fromEmail, String fromPasswd, String fromName, String host, List<String> toEmailList, MailMsg mailMsg) {
        HtmlEmail email = new HtmlEmail();
        try {
            this.initEmail((Email)email, fromEmail, fromPasswd, fromName, host, toEmailList, mailMsg);
            email.setHtmlMsg(mailMsg.getContent());
            email.send();
        }
        catch (EmailException e) {
            e.printStackTrace();
        }
    }

    private void sendMultiMail(String fromEmail, String fromPasswd, String fromName, String host, List<String> toEmailList, MailMsg mailMsg) {
        HtmlEmail email = new HtmlEmail();
        try {
            this.initEmail((Email)email, fromEmail, fromPasswd, fromName, host, toEmailList, mailMsg);
            email.setHtmlMsg(mailMsg.getContent());
            List<MailAttach> attachList = mailMsg.getAttachList();
            EmailAttachment attachment = null;
            for (MailAttach mailAttach : attachList) {
                attachment = new EmailAttachment();
                attachment.setDisposition("attachment");
                attachment.setName(mailAttach.getName());
                attachment.setDescription(mailAttach.getDescription());
                attachment.setPath(mailAttach.getPath());
                attachment.setURL(mailAttach.getUrl());
                email.attach(attachment);
            }
            email.send();
        }
        catch (EmailException e) {
            e.printStackTrace();
        }
    }

    private void initEmail(Email email, String fromEmail, String fromPasswd, String fromName, String host, List<String> toEmailList, MailMsg mailMsg) throws EmailException {
        email.setHostName(host);
        email.setAuthentication(fromEmail, fromPasswd);
        email.setCharset(MailCfg.CHARSET);
        email.setDebug(false);
        email.setSSLOnConnect(true);
        email.setStartTLSEnabled(true);
        email.addTo(toEmailList.toArray(new String[0]));
        email.setFrom(fromEmail, fromName);
        email.setSubject(mailMsg.getSubject());
    }
}

