package config;

import com.liuwa.configuration.common.ConfigProperties;
import com.liuwa.configuration.common.GlobalProperties;

/**
 * 达达配置
 */
public class DaDaProperties {

    private static final ConfigProperties properties = new ConfigProperties("dada.properties");

    /**
     * 获取配置属性
     * @param key
     * @return
     */
    public static String getProperty(String key) {
        String value = properties.getProperty(key);
        if(value == null){
            value = GlobalProperties.getProperty(key);
        }
        return value;
    }

    /**
     * 获取配置属性
     * @param key
     * @param defaultValue
     * @return
     */
    public static String getProperty(String key, String defaultValue) {
        String value =  properties.getProperty(key, defaultValue);
        if(value == null){
            value = GlobalProperties.getProperty(key);
        }
        return value;
    }

    /**
     * 获取配置属性
     * @param key
     * @return
     */
    public static boolean getPropertyForBoolean(String key){
        return getPropertyForBoolean(key, null);
    }

    /**
     * 获取配置属性
     * @param key
     * @param defaultValue
     * @return
     */
    public static boolean getPropertyForBoolean(String key, Boolean defaultValue){
        Boolean value =  properties.getPropertyForBoolean(key);
        if(value == null){
            value = GlobalProperties.getPropertyForBoolean(key);
        }
        if(defaultValue != null && value == null){
            return defaultValue;
        }
        return value;
    }
}
