import client.DadaApiResponse;
import client.DadaRequestClient;
import config.AppConfig;
import domain.merchant.MerchantAddModel;
import domain.merchant.ShopAddModel;
import domain.order.OrderAddModel;
import domain.order.OrderQueryDeliverFeeModel;
import domain.order.OrderQueryModel;
import service.CityCodeService;
import service.merchant.MerchantAddService;
import service.merchant.ShopAddService;
import service.order.*;
import utils.DaDaApiUtils;
import utils.JSONUtil;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * DATE: 18/9/4
 *
 * @author: wan
 */
public class example {

    /**
     * 创建订单
     * @return
     *
     *
     * 同步响应：{"code":0,"msg":"成功","result":{"insuranceFee":0.0,"distance":3135259.6686146017,"fee":12.0,"deliverFee":12.0,"tips":0.0},"status":"success"}
     * 异步数据：{"cancel_from":"0","cancel_reason":"","client_id":"977435770693085349","dm_id":"0","dm_mobile":"","dm_name":"","order_id":"1619751945130","order_status":"1","signature":"3e6fe7c78956176c6b8204236eb6f0ce","update_time":"1619751987"}
     */
    private static DadaApiResponse addOrder(String orderId) {
        // 1.初始化配置(isOnline表示是否测试环境)
        AppConfig appConfig = new AppConfig(false);
        appConfig.setSourceId("79558");

        // 2.初始化model
        OrderAddModel orderAddModel = new OrderAddModel();
        orderAddModel.setShopNo("79558-85887");
        orderAddModel.setOriginId(orderId);
        orderAddModel.setCityCode("0592");
        orderAddModel.setCargoPrice(BigDecimal.valueOf(111));
        orderAddModel.setIsPrepay(0);
        // 填写收货人信息
        orderAddModel.setReceiverName("测试收货人");
        orderAddModel.setReceiverAddress("测试地址");
        orderAddModel.setReceiverLat(BigDecimal.valueOf(11.11111228623));
        orderAddModel.setReceiverLng(BigDecimal.valueOf(121.587172));
        orderAddModel.setReceiverPhone("17759227187");
        // 设置回调url, 订单状态每次变更就会往该url发送通知(参见回调接口)
        orderAddModel.setCallback("http://zhiquanlaw.com/cunnar/createweb/notify_url");

        // 3.初始化service
        OrderAddService orderService = new OrderAddService(orderAddModel.toJson());

        // 4.初始化客户端
        DadaRequestClient dadaClient = new DadaRequestClient(orderService, appConfig);
        return dadaClient.callRpc();


    }

    /**
     * 重发订单
     * @param orderId
     * @return
     */
    private static DadaApiResponse reAddOrder(String orderId) {
        // 1.初始化配置(isOnline表示是否测试环境)
        AppConfig appConfig = new AppConfig(false);
        appConfig.setSourceId("79558");

        // 2.初始化model
        OrderAddModel orderAddModel = new OrderAddModel();
        orderAddModel.setShopNo("79558-85887");
        orderAddModel.setOriginId(orderId);
        orderAddModel.setCityCode("0592");
        orderAddModel.setCargoPrice(BigDecimal.valueOf(111));
        orderAddModel.setIsPrepay(0);
        // 填写收货人信息
        orderAddModel.setReceiverName("测试收货人");
        orderAddModel.setReceiverAddress("测试地址");
        orderAddModel.setReceiverLat(BigDecimal.valueOf(11.11111228623));
        orderAddModel.setReceiverLng(BigDecimal.valueOf(121.587172));
        orderAddModel.setReceiverPhone("17759227187");
        // 设置回调url, 订单状态每次变更就会往该url发送通知(参见回调接口)
        orderAddModel.setCallback("http://zhiquanlaw.com/cunnar/createweb/notify_url");

        // 3.初始化service
        OrderReAddService orderService = new OrderReAddService(orderAddModel.toJson());

        // 4.初始化客户端
        DadaRequestClient dadaClient = new DadaRequestClient(orderService, appConfig);
        return dadaClient.callRpc();


    }


    /**
     * 查询运费
     * @param orderId
     * @return
     */
    private static DadaApiResponse queryDeliverFee(String orderId) {
        // 1.初始化配置(isOnline表示是否测试环境)
        AppConfig appConfig = new AppConfig(false);
        appConfig.setSourceId("79558");

        // 2.初始化model
        OrderQueryDeliverFeeModel model = new OrderQueryDeliverFeeModel();
        model.setShopNo("79558-85887");
        model.setOriginId(orderId);
        model.setCityCode("0592");
        model.setCargoPrice(BigDecimal.valueOf(111));
        model.setIsPrepay(0);
        // 填写收货人信息
        model.setReceiverName("测试收货人");
        model.setReceiverAddress("厦门市软件园二期44号楼1201");
        /*model.setReceiverLat(BigDecimal.valueOf(11.11111228623));
        model.setReceiverLng(BigDecimal.valueOf(121.587172));*/
        model.setReceiverPhone("17759227187");
        // 设置回调url, 订单状态每次变更就会往该url发送通知(参见回调接口)
        model.setCallback("http://zhiquanlaw.com/cunnar/createweb/notify_url");

        // 3.初始化service
        OrderQueryDeliverFeeService orderService = new OrderQueryDeliverFeeService(model.toJson());

        // 4.初始化客户端
        DadaRequestClient dadaClient = new DadaRequestClient(orderService, appConfig);
        return dadaClient.callRpc();

    }

    /**
     * 模拟接单
     * @param orderId
     * @return
     * 异步通知 {"cancel_from":"0","cancel_reason":"","client_id":"977435770694374042","dm_id":"666","dm_mobile":"13546670420","dm_name":"达达骑手","order_id":"DD202104301126442244","order_status":"2","signature":"fa12ecee3720a74504b1eb59f66b4b39","update_time":"1619753346"}
     */
    private static DadaApiResponse  acceptOrder(String orderId){
        // 1.初始化配置(isOnline表示是否测试环境)
        AppConfig appConfig = new AppConfig(false);
        appConfig.setSourceId("79558");

        // 2.初始化model
        OrderQueryModel model = new OrderQueryModel();
        model.setOrderId(orderId);

        // 3.初始化service
        OrderAcceptService orderService = new OrderAcceptService(model.toJson());

        // 4.初始化客户端
        DadaRequestClient dadaClient = new DadaRequestClient(orderService, appConfig);
        return dadaClient.callRpc();
    }

    /**
     * 模拟取货
     * @param orderId
     * @return
     */
    private static DadaApiResponse  fetchOrder(String orderId){
        // 1.初始化配置(isOnline表示是否测试环境)
        AppConfig appConfig = new AppConfig(false);
        appConfig.setSourceId("79558");

        // 2.初始化model
        OrderQueryModel model = new OrderQueryModel();
        model.setOrderId(orderId);

        // 3.初始化service
        OrderFetchService orderService = new OrderFetchService(model.toJson());

        // 4.初始化客户端
        DadaRequestClient dadaClient = new DadaRequestClient(orderService, appConfig);
        return dadaClient.callRpc();
    }


    /**
     * 查询订单
     * @param orderId
     * @return
     * {"code":0,"msg":"成功","result":{"supplierName":"票务","supplierLat":"31.228624","supplierAddress":"厦门市软件园二期44号1808","finishTime":"","distance":3135259,"orderId":"DD202104301126442244","supplierLng":"121.587173","tips":0.0,"supplierPhone":"17759227187","transporterName":"","transporterLat":"","deliveryFee":12.0,"insuranceFee":0.0,"statusMsg":"待接单","transporterLng":"","createTime":"2021-04-30 11:43:03","cancelTime":"","transporterPhone":"","fetchTime":"","receiptUrl":"","actualFee":12.0,"orderFinishCode":"0","statusCode":1},"status":"success"}
     */
    private static DadaApiResponse  queryOrder(String orderId){
        // 1.初始化配置(isOnline表示是否测试环境)
        AppConfig appConfig = new AppConfig(false);
        appConfig.setSourceId("79558");

        // 2.初始化model
        OrderQueryModel model = new OrderQueryModel();
        model.setOrderId(orderId);

        // 3.初始化service
        OrderQueryService orderService = new OrderQueryService(model.toJson());

        // 4.初始化客户端
        DadaRequestClient dadaClient = new DadaRequestClient(orderService, appConfig);
        return dadaClient.callRpc();
    }

    /**
     * 新增店铺
     * @return
     * {"code":0,"msg":"成功","result":{"successList":[{"business":2,"cityName":"厦门","lng":121.587173,"phone":"17759227187","areaName":"思明区","contactName":"杨某某","originShopId":"79558-85887","stationName":"票务","stationAddress":"厦门市软件园二期44号1808","lat":31.228624}],"success":1,"failedList":[]},"status":"success"}
     */
    private static DadaApiResponse addShop() {

        // 1.初始化配置(isOnline表示是否测试环境)
        AppConfig appConfig = new AppConfig(false);
        appConfig.setSourceId("79558");


        // 2.初始化model
        ShopAddModel shopAddModel = new ShopAddModel();
        // 根据实际信息来填写门店地址
        //shopAddModel.setOriginShopId("xxxxxxxxxxxxxxxx");
        shopAddModel.setStationName("票务");
        shopAddModel.setBusiness(2);
        shopAddModel.setCityName("厦门");
        shopAddModel.setAreaName("思明区");
        shopAddModel.setStationAddress("厦门市软件园二期44号1808");
        shopAddModel.setLng(BigDecimal.valueOf(121.587173));
        shopAddModel.setLat(BigDecimal.valueOf(31.228624));
        shopAddModel.setContactName("杨某某");
        shopAddModel.setPhone("17759227187");

        // 3.初始化service (门店新增比较特殊,是一个批量新增接口)
        List<ShopAddModel> shopAddList = new ArrayList<ShopAddModel>();
        shopAddList.add(shopAddModel);
        ShopAddService shopAddService = new ShopAddService(JSONUtil.toJson(shopAddList));


        // 4.初始化客户端
        DadaRequestClient dadaClient = new DadaRequestClient(shopAddService, appConfig);
        return dadaClient.callRpc();
    }


    private static DadaApiResponse queryCityCode(){
       return DaDaApiUtils.queryCityCode(79558);
    }

    /**
     * 注册商户
     * @return
     */
    private static DadaApiResponse registerMerchant(){
        String phone = "17723772233";
        MerchantAddModel model = new MerchantAddModel();
        model.setMobile(phone);
        model.setCityName("厦门市");
        model.setEnterpriseName("厦门科技有限公司");
        model.setEnterpriseAddress("厦门市软件园二期44号1808");
        model.setContactName("杨某某");
        model.setContactPhone(phone);
        model.setEmail(phone + "@dada.com");

       return DaDaApiUtils.registerMerchant(model);

    }



    public static void main(String[] args) {
        String orderId = "DD202105061126442244";
        //DadaApiResponse resp =addOrder(orderId);
        //DadaApiResponse resp = registerMerchant();
        Map<String, String> map = DaDaApiUtils.getCityCodeMap(79558);
        System.out.println(JSONUtil.toJson(map));
    }
}
