/*
 * Decompiled with CFR 0.152.
 */
package com.lazada.lazop.api;

import com.lazada.lazop.api.ILazopClient;
import com.lazada.lazop.api.LazopRequest;
import com.lazada.lazop.api.LazopResponse;
import com.lazada.lazop.util.ApiException;
import com.lazada.lazop.util.LazopHashMap;
import com.lazada.lazop.util.LazopLogger;
import com.lazada.lazop.util.LazopUtils;
import com.lazada.lazop.util.RequestContext;
import com.lazada.lazop.util.WebUtils;
import com.lazada.lazop.util.json.JSONReader;
import com.lazada.lazop.util.json.JSONValidatingReader;
import java.io.IOException;
import java.net.Proxy;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class LazopClient
implements ILazopClient {
    protected String serverUrl;
    protected String appKey;
    protected String appSecret;
    protected String signMethod = "sha256";
    protected int connectTimeout = 15000;
    protected int readTimeout = 30000;
    protected boolean useGzipEncoding = true;
    protected Proxy proxy;
    protected String sdkVersion = "lazop-sdk-java-20181207";
    protected String logLevel = "ERROR";

    public LazopClient(String serverUrl, String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.serverUrl = serverUrl;
    }

    public LazopClient(String serverUrl, String appKey, String appSecret, int connectTimeout, int readTimeout) {
        this(serverUrl, appKey, appSecret);
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    @Override
    public LazopResponse execute(LazopRequest request) throws ApiException {
        return this.execute(request, null);
    }

    @Override
    public LazopResponse execute(LazopRequest request, String accessToken) throws ApiException {
        return this.doExecute(request, accessToken);
    }

    private LazopResponse doExecute(LazopRequest request, String accessToken) throws ApiException {
        long start = System.currentTimeMillis();
        RequestContext requestContext = new RequestContext();
        LazopHashMap bizParams = new LazopHashMap(request.getApiParams() != null ? request.getApiParams() : new HashMap());
        requestContext.setQueryParams(bizParams);
        requestContext.setApiName(request.getApiName());
        LazopHashMap commonParams = new LazopHashMap();
        commonParams.put("app_key", this.appKey);
        Long timestamp = request.getTimestamp();
        if (timestamp == null) {
            timestamp = System.currentTimeMillis();
        }
        commonParams.put("timestamp", (Object)new Date(timestamp));
        commonParams.put("sign_method", this.signMethod);
        commonParams.put("access_token", accessToken);
        commonParams.put("partner_id", this.sdkVersion);
        if (this.isDebugEnabled()) {
            commonParams.put("debug", (Object)true);
        }
        requestContext.setCommonParams(commonParams);
        try {
            commonParams.put("sign", LazopUtils.signApiRequest(requestContext, this.appSecret, this.signMethod));
            String rpcUrl = WebUtils.buildRestUrl(this.serverUrl, request.getApiName());
            String urlQuery = WebUtils.buildQuery(requestContext.getCommonParams(), "UTF-8");
            String fullUrl = WebUtils.buildRequestUrl(rpcUrl, urlQuery);
            String rsp = null;
            if (this.useGzipEncoding) {
                request.addHeaderParameter("Accept-Encoding", "gzip");
            }
            rsp = request.getFileParams() != null ? WebUtils.doPost(fullUrl, (Map<String, String>)bizParams, request.getFileParams(), request.getHeaderParams(), "UTF-8", this.connectTimeout, this.readTimeout) : (request.getHttpMethod().equals("POST") ? WebUtils.doPost(fullUrl, (Map<String, String>)bizParams, request.getHeaderParams(), "UTF-8", this.connectTimeout, this.readTimeout, this.proxy) : WebUtils.doGet(fullUrl, bizParams, request.getHeaderParams(), this.connectTimeout, this.readTimeout, "UTF-8", this.proxy));
            requestContext.setResponseBody(rsp);
        }
        catch (IOException e) {
            LazopLogger.write(this.appKey, this.sdkVersion, request.getApiName(), this.serverUrl, requestContext.getAllParams(), System.currentTimeMillis() - start, e.toString());
            throw new ApiException(e);
        }
        catch (Exception e) {
            LazopLogger.write(this.appKey, this.sdkVersion, request.getApiName(), this.serverUrl, requestContext.getAllParams(), System.currentTimeMillis() - start, e.toString());
            throw new ApiException(e);
        }
        LazopResponse response = this.parseResponse(requestContext.getResponseBody());
        if (!response.isSuccess()) {
            LazopLogger.write(this.appKey, this.sdkVersion, request.getApiName(), this.serverUrl, requestContext.getAllParams(), System.currentTimeMillis() - start, response.getBody());
        } else if (this.isDebugEnabled() || this.isInfoEnabled()) {
            LazopLogger.write(this.appKey, this.sdkVersion, request.getApiName(), this.serverUrl, requestContext.getAllParams(), System.currentTimeMillis() - start, "");
        }
        return response;
    }

    private LazopResponse parseResponse(String jsonRsp) {
        JSONValidatingReader reader = new JSONValidatingReader();
        Map root = (Map)((JSONReader)reader).read(jsonRsp);
        LazopResponse response = new LazopResponse();
        response.setType((String)root.get("type"));
        response.setCode((String)root.get("code"));
        response.setMessage((String)root.get("message"));
        response.setRequestId((String)root.get("request_id"));
        response.setBody(jsonRsp);
        return response;
    }

    public void setNeedEnableLogger(boolean needEnableLogger) {
        LazopLogger.setNeedEnableLogger(needEnableLogger);
    }

    public void setIgnoreSSLCheck(boolean ignore) {
        WebUtils.setIgnoreSSLCheck(ignore);
    }

    public void setUseGzipEncoding(boolean useGzipEncoding) {
        this.useGzipEncoding = useGzipEncoding;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setSignMethod(String signMethod) {
        this.signMethod = signMethod;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public boolean isDebugEnabled() {
        return this.logLevel.equals("DEBUG");
    }

    public boolean isInfoEnabled() {
        return this.logLevel.equals("INFO");
    }

    public boolean isErrorEnabled() {
        return this.logLevel.equals("ERROR");
    }
}

