/*
 * Decompiled with CFR 0.152.
 */
package com.lazada.lazop.util;

import com.lazada.lazop.util.LazopUtils;
import com.lazada.lazop.util.WebUtils;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LazopLogger {
    private static final Log log = LogFactory.getLog(LazopLogger.class);
    private static final String LOG_SPLIT = "^_^";
    private static String osName = System.getProperties().getProperty("os.name");
    private static boolean needEnableLogger = true;

    public static void setNeedEnableLogger(boolean needEnableLogger) {
        LazopLogger.needEnableLogger = needEnableLogger;
    }

    public static void write(String appKey, String sdkVersion, String apiName, String url, Map<String, String> params, long latency, String errorMessage) {
        if (!needEnableLogger) {
            return;
        }
        StringBuilder sb = LazopLogger.buildLogApi(appKey, sdkVersion, apiName, url, params, latency, errorMessage);
        log.error((Object)sb.toString());
    }

    private static StringBuilder buildLogApi(String appKey, String sdkVersion, String apiName, String url, Map<String, String> params, long latency, String errorMessage) {
        StringBuilder sb = new StringBuilder();
        sb.append(LazopLogger.formatDateTime(new Date()));
        sb.append(LOG_SPLIT);
        sb.append(appKey);
        sb.append(LOG_SPLIT);
        sb.append(sdkVersion);
        sb.append(LOG_SPLIT);
        sb.append(apiName);
        sb.append(LOG_SPLIT);
        sb.append(LazopUtils.getIntranetIp());
        sb.append(LOG_SPLIT);
        sb.append(osName);
        sb.append(LOG_SPLIT);
        sb.append(latency);
        sb.append(LOG_SPLIT);
        sb.append(url);
        try {
            sb.append(LOG_SPLIT);
            sb.append(WebUtils.buildQuery(params, "utf-8"));
        }
        catch (IOException e) {
            // empty catch block
        }
        sb.append(LOG_SPLIT);
        sb.append(errorMessage);
        return sb;
    }

    private static String formatDateTime(Date date) {
        return LazopUtils.formatDateTime(date, "yyyy-MM-dd HH:mm:ss.SSS");
    }
}

