/*
 * Decompiled with CFR 0.152.
 */
package com.lazada.lazop.util.json;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class JSONReader {
    private static final Object OBJECT_END = new Object();
    private static final Object ARRAY_END = new Object();
    private static final Object COLON = new Object();
    private static final Object COMMA = new Object();
    public static final int FIRST = 0;
    public static final int CURRENT = 1;
    public static final int NEXT = 2;
    private static Map<Character, Character> escapes = new HashMap<Character, Character>();
    private CharacterIterator it;
    private char c;
    private Object token;
    private StringBuffer buf = new StringBuffer();

    private char next() {
        this.c = this.it.next();
        return this.c;
    }

    private void skipWhiteSpace() {
        while (Character.isWhitespace(this.c)) {
            this.next();
        }
    }

    public Object read(CharacterIterator ci, int start) {
        this.it = ci;
        switch (start) {
            case 0: {
                this.c = this.it.first();
                break;
            }
            case 1: {
                this.c = this.it.current();
                break;
            }
            case 2: {
                this.c = this.it.next();
            }
        }
        return this.read();
    }

    public Object read(CharacterIterator it) {
        return this.read(it, 2);
    }

    public Object read(String string) {
        return this.read(new StringCharacterIterator(string), 0);
    }

    private Object read() {
        this.skipWhiteSpace();
        char ch = this.c;
        this.next();
        switch (ch) {
            case '\"': {
                this.token = this.string();
                break;
            }
            case '[': {
                this.token = this.array();
                break;
            }
            case ']': {
                this.token = ARRAY_END;
                break;
            }
            case ',': {
                this.token = COMMA;
                break;
            }
            case '{': {
                this.token = this.object();
                break;
            }
            case '}': {
                this.token = OBJECT_END;
                break;
            }
            case ':': {
                this.token = COLON;
                break;
            }
            case 't': {
                this.next();
                this.next();
                this.next();
                this.token = Boolean.TRUE;
                break;
            }
            case 'f': {
                this.next();
                this.next();
                this.next();
                this.next();
                this.token = Boolean.FALSE;
                break;
            }
            case 'n': {
                this.next();
                this.next();
                this.next();
                this.token = null;
                break;
            }
            default: {
                this.c = this.it.previous();
                if (!Character.isDigit(this.c) && this.c != '-') break;
                this.token = this.number();
            }
        }
        return this.token;
    }

    private Object object() {
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        Object key = this.read();
        while (this.token != OBJECT_END) {
            this.read();
            if (this.token == OBJECT_END) continue;
            ret.put(key, this.read());
            if (this.read() != COMMA) continue;
            key = this.read();
        }
        return ret;
    }

    private Object array() {
        ArrayList<Object> ret = new ArrayList<Object>();
        Object value = this.read();
        while (this.token != ARRAY_END) {
            ret.add(value);
            if (this.read() != COMMA) continue;
            value = this.read();
        }
        return ret;
    }

    private Object number() {
        int length = 0;
        boolean isFloatingPoint = false;
        this.buf.setLength(0);
        if (this.c == '-') {
            this.add();
        }
        length += this.addDigits();
        if (this.c == '.') {
            this.add();
            length += this.addDigits();
            isFloatingPoint = true;
        }
        if (this.c == 'e' || this.c == 'E') {
            this.add();
            if (this.c == '+' || this.c == '-') {
                this.add();
            }
            this.addDigits();
            isFloatingPoint = true;
        }
        String s = this.buf.toString();
        return isFloatingPoint ? (Number)(length < 17 ? Double.valueOf(s) : new BigDecimal(s)) : (Number)(length < 19 ? Long.valueOf(s) : new BigInteger(s));
    }

    private int addDigits() {
        int ret = 0;
        while (Character.isDigit(this.c)) {
            this.add();
            ++ret;
        }
        return ret;
    }

    private Object string() {
        this.buf.setLength(0);
        while (this.c != '\"') {
            if (this.c == '\\') {
                this.next();
                if (this.c == 'u') {
                    this.add(this.unicode());
                    continue;
                }
                Character value = escapes.get(Character.valueOf(this.c));
                if (value == null) continue;
                this.add(value.charValue());
                continue;
            }
            this.add();
        }
        this.next();
        return this.buf.toString();
    }

    private void add(char cc) {
        this.buf.append(cc);
        this.next();
    }

    private void add() {
        this.add(this.c);
    }

    private char unicode() {
        int value = 0;
        block5: for (int i = 0; i < 4; ++i) {
            switch (this.next()) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    value = (value << 4) + this.c - 48;
                    continue block5;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    value = (value << 4) + this.c - 107;
                    continue block5;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    value = (value << 4) + this.c - 75;
                }
            }
        }
        return (char)value;
    }

    static {
        escapes.put(Character.valueOf('\"'), Character.valueOf('\"'));
        escapes.put(Character.valueOf('\\'), Character.valueOf('\\'));
        escapes.put(Character.valueOf('/'), Character.valueOf('/'));
        escapes.put(Character.valueOf('b'), Character.valueOf('\b'));
        escapes.put(Character.valueOf('f'), Character.valueOf('\f'));
        escapes.put(Character.valueOf('n'), Character.valueOf('\n'));
        escapes.put(Character.valueOf('r'), Character.valueOf('\r'));
        escapes.put(Character.valueOf('t'), Character.valueOf('\t'));
    }
}

