package com.liuwa.unicloud.cache;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 本地存储
 */
public class LocalStorage {

    private static Logger logger = LoggerFactory.getLogger(LocalStorage.class);

    /**
     * 缓存映射
     */
    private static Map<String, Cache> cacheMap = new HashMap<String, Cache>();

     static {
         new Thread(new Runnable() {
             @Override
             public void run() {
                 while(true){
                     try{
                         // 1 分钟检测一次
                         Thread.sleep(60000);
                         List<String> expiredKeys = new ArrayList<String>();
                         for(Map.Entry<String, Cache> entry : cacheMap.entrySet()){
                             Cache cache = entry.getValue();
                             if(cache.getExpireAt() != null && cache.getExpireAt() < System.currentTimeMillis()){
                                 logger.info("缓存到期：{}", entry.getKey());
                                 expiredKeys.add(entry.getKey());
                             }
                         }
                         for(String key : expiredKeys){
                             cacheMap.remove(key);
                         }
                     }
                     catch (Exception ex){
                         logger.error(ex.getMessage(), ex);
                     }
                 }

             }
         }).start();
     }

    /**
     * 获取缓存
     * @param key
     * @return
     */
    public static String get(String key){
        if(!cacheMap.containsKey(key)){
            return null;
        }
        Cache cache = cacheMap.get(key);
        if(cache.getExpireAt() != null && cache.getExpireAt() < System.currentTimeMillis()){
            cacheMap.remove(key);
            return null;
        }
        return (String)cache.getData();
    }

    /**
     * 设置缓存
     * @param key
     * @param value
     * @param expiresInSecond
     */
    public static void set(String key, String value, int expiresInSecond){
        Cache cache = new Cache();
        cache.setData(value);
        if(expiresInSecond > 0){
            cache.setExpireAt(System.currentTimeMillis() + expiresInSecond * 1000);
        }
        cacheMap.put(key, cache);
    }
}
