package com.liuwa.unicloud.common;

import com.liuwa.configuration.common.ConfigProperties;
import com.liuwa.configuration.common.GlobalProperties;

/**
 * uni Cloud配置
 * @author Rubekid
 *
 * 2017年3月31日 下午8:41:29
 */
public class UniCloudProperties{

	private static final ConfigProperties properties = new ConfigProperties("unicloud.properties");

    /**
     * 获取配置属性
     * @param key
     * @return
     */
    public static String getProperty(String key) {
        String value = properties.getProperty(key);
        if(value == null){
            value = GlobalProperties.getProperty(key);
        }
        return value;
    }

    /**
     * 获取配置属性
     * @param key
     * @param defaultValue
     * @return
     */
    public static String getProperty(String key, String defaultValue) {
        String value =  properties.getProperty(key, defaultValue);
        if(value == null){
            value = GlobalProperties.getProperty(key);
        }
        return value;
    }


}