package com.liuwa.unicloud.http;


import com.liuwa.http.HttpResponse;
import com.liuwa.unicloud.common.UniCloudProperties;
import net.sf.json.JSONObject;

import java.util.LinkedHashMap;

/**
 * Uni Cloud
 */
public class UniCloudHttpClient extends CloudHttpClient{

    private CloudHttpClient httpClient;

    /**
     * 阿里云
     */
    public static final String PROVIDER_ALIYUN = "aliyun";

    /**
     * 腾讯云
     */
    public static final String PROVIDER_TENCENT = "tencent";

    /**
     * 供应商
     */
    private static final String PROVIDER = UniCloudProperties.getProperty("unicloud.provider");

    /**
     * 构造函数
     */
    public UniCloudHttpClient(){
        this(PROVIDER);
    }

    /**
     * 构造函数
     * @param provider
     */
    public UniCloudHttpClient(String provider){
        httpClient = PROVIDER_TENCENT.equals(provider) ? new TencentCloudHttpClient() : new AliyunHttpClient();
    }

    @Override
    public JSONObject request(String url, LinkedHashMap<String, Object> config) {
        return httpClient.request(url, config);
    }

    @Override
    public HttpResponse parse(JSONObject json) {
        return httpClient.parse(json);
    }
}