/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.NameResolver;
import com.unboundid.util.Debug;
import com.unboundid.util.ExampleCommandLineArgument;
import com.unboundid.util.LDAPSDKException;
import com.unboundid.util.LDAPSDKRuntimeException;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.Validator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.UUID;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class StaticUtils {
    public static final byte[] NO_BYTES = new byte[0];
    public static final char[] NO_CHARS = new char[0];
    public static final Control[] NO_CONTROLS = new Control[0];
    public static final String[] NO_STRINGS = new String[0];
    public static final String EOL = StaticUtils.getSystemProperty("line.separator", "\n");
    public static final byte[] EOL_BYTES = StaticUtils.getBytes(EOL);
    private static final boolean IS_WITHIN_UNIT_TESTS = Boolean.getBoolean("com.unboundid.ldap.sdk.RunningUnitTests") || Boolean.getBoolean("com.unboundid.directory.server.RunningUnitTests");
    public static final int TERMINAL_WIDTH_COLUMNS;
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMATTERS;
    private static final TimeZone UTC_TIME_ZONE;
    private static volatile Set<String> TO_CODE_SENSITIVE_ATTRIBUTE_NAMES;

    private StaticUtils() {
    }

    public static byte[] getBytes(String s) {
        int length;
        if (s == null || (length = s.length()) == 0) {
            return NO_BYTES;
        }
        byte[] b = new byte[length];
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c > '\u007f') {
                return s.getBytes(StandardCharsets.UTF_8);
            }
            b[i] = (byte)(c & 0x7F);
        }
        return b;
    }

    public static boolean isASCIIString(byte[] b) {
        for (byte by : b) {
            if ((by & 0x80) != 128) continue;
            return false;
        }
        return true;
    }

    public static boolean isPrintable(char c) {
        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
            return true;
        }
        switch (c) {
            case ' ': 
            case '\'': 
            case '(': 
            case ')': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case '=': 
            case '?': {
                return true;
            }
        }
        return false;
    }

    public static boolean isPrintableString(byte[] b) {
        block3: for (byte by : b) {
            if ((by & 0x80) == 128) {
                return false;
            }
            if (by >= 97 && by <= 122 || by >= 65 && by <= 90 || by >= 48 && by <= 57) continue;
            switch (by) {
                case 32: 
                case 39: 
                case 40: 
                case 41: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 58: 
                case 61: 
                case 63: {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isValidUTF8(byte[] b) {
        int i = 0;
        while (i < b.length) {
            byte currentByte;
            if (((currentByte = b[i++]) & 0x80) == 0) continue;
            if ((currentByte & 0xE0) == 192) {
                if (!StaticUtils.hasExpectedSubsequentUTF8Bytes(b, i, 1)) {
                    return false;
                }
                ++i;
                continue;
            }
            if ((currentByte & 0xF0) == 224) {
                if (!StaticUtils.hasExpectedSubsequentUTF8Bytes(b, i, 2)) {
                    return false;
                }
                i += 2;
                continue;
            }
            if ((currentByte & 0xF8) == 240) {
                if (!StaticUtils.hasExpectedSubsequentUTF8Bytes(b, i, 3)) {
                    return false;
                }
                i += 3;
                continue;
            }
            if ((currentByte & 0xFC) == 248) {
                if (!StaticUtils.hasExpectedSubsequentUTF8Bytes(b, i, 4)) {
                    return false;
                }
                i += 4;
                continue;
            }
            if ((currentByte & 0xFE) == 252) {
                if (!StaticUtils.hasExpectedSubsequentUTF8Bytes(b, i, 5)) {
                    return false;
                }
                i += 5;
                continue;
            }
            return false;
        }
        return true;
    }

    private static boolean hasExpectedSubsequentUTF8Bytes(byte[] b, int p, int n) {
        if (b.length < p + n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if ((b[p + i] & 0xC0) == 128) continue;
            return false;
        }
        return true;
    }

    public static String toUTF8String(byte[] b) {
        try {
            return new String(b, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return new String(b);
        }
    }

    public static String toUTF8String(byte[] b, int offset, int length) {
        try {
            return new String(b, offset, length, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return new String(b, offset, length);
        }
    }

    public static String toInitialLowerCase(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        if (s.length() == 1) {
            return StaticUtils.toLowerCase(s);
        }
        char c = s.charAt(0);
        if (c >= 'A' && c <= 'Z' || c < ' ' || c > '~') {
            StringBuilder b = new StringBuilder(s);
            b.setCharAt(0, Character.toLowerCase(c));
            return b.toString();
        }
        return s;
    }

    public static String toLowerCase(String s) {
        if (s == null) {
            return null;
        }
        int length = s.length();
        char[] charArray = s.toCharArray();
        block28: for (int i = 0; i < length; ++i) {
            switch (charArray[i]) {
                case 'A': {
                    charArray[i] = 97;
                    continue block28;
                }
                case 'B': {
                    charArray[i] = 98;
                    continue block28;
                }
                case 'C': {
                    charArray[i] = 99;
                    continue block28;
                }
                case 'D': {
                    charArray[i] = 100;
                    continue block28;
                }
                case 'E': {
                    charArray[i] = 101;
                    continue block28;
                }
                case 'F': {
                    charArray[i] = 102;
                    continue block28;
                }
                case 'G': {
                    charArray[i] = 103;
                    continue block28;
                }
                case 'H': {
                    charArray[i] = 104;
                    continue block28;
                }
                case 'I': {
                    charArray[i] = 105;
                    continue block28;
                }
                case 'J': {
                    charArray[i] = 106;
                    continue block28;
                }
                case 'K': {
                    charArray[i] = 107;
                    continue block28;
                }
                case 'L': {
                    charArray[i] = 108;
                    continue block28;
                }
                case 'M': {
                    charArray[i] = 109;
                    continue block28;
                }
                case 'N': {
                    charArray[i] = 110;
                    continue block28;
                }
                case 'O': {
                    charArray[i] = 111;
                    continue block28;
                }
                case 'P': {
                    charArray[i] = 112;
                    continue block28;
                }
                case 'Q': {
                    charArray[i] = 113;
                    continue block28;
                }
                case 'R': {
                    charArray[i] = 114;
                    continue block28;
                }
                case 'S': {
                    charArray[i] = 115;
                    continue block28;
                }
                case 'T': {
                    charArray[i] = 116;
                    continue block28;
                }
                case 'U': {
                    charArray[i] = 117;
                    continue block28;
                }
                case 'V': {
                    charArray[i] = 118;
                    continue block28;
                }
                case 'W': {
                    charArray[i] = 119;
                    continue block28;
                }
                case 'X': {
                    charArray[i] = 120;
                    continue block28;
                }
                case 'Y': {
                    charArray[i] = 121;
                    continue block28;
                }
                case 'Z': {
                    charArray[i] = 122;
                    continue block28;
                }
                default: {
                    if (charArray[i] <= '\u007f') continue block28;
                    return s.toLowerCase();
                }
            }
        }
        return new String(charArray);
    }

    public static String toUpperCase(String s) {
        if (s == null) {
            return null;
        }
        int length = s.length();
        char[] charArray = s.toCharArray();
        block28: for (int i = 0; i < length; ++i) {
            switch (charArray[i]) {
                case 'a': {
                    charArray[i] = 65;
                    continue block28;
                }
                case 'b': {
                    charArray[i] = 66;
                    continue block28;
                }
                case 'c': {
                    charArray[i] = 67;
                    continue block28;
                }
                case 'd': {
                    charArray[i] = 68;
                    continue block28;
                }
                case 'e': {
                    charArray[i] = 69;
                    continue block28;
                }
                case 'f': {
                    charArray[i] = 70;
                    continue block28;
                }
                case 'g': {
                    charArray[i] = 71;
                    continue block28;
                }
                case 'h': {
                    charArray[i] = 72;
                    continue block28;
                }
                case 'i': {
                    charArray[i] = 73;
                    continue block28;
                }
                case 'j': {
                    charArray[i] = 74;
                    continue block28;
                }
                case 'k': {
                    charArray[i] = 75;
                    continue block28;
                }
                case 'l': {
                    charArray[i] = 76;
                    continue block28;
                }
                case 'm': {
                    charArray[i] = 77;
                    continue block28;
                }
                case 'n': {
                    charArray[i] = 78;
                    continue block28;
                }
                case 'o': {
                    charArray[i] = 79;
                    continue block28;
                }
                case 'p': {
                    charArray[i] = 80;
                    continue block28;
                }
                case 'q': {
                    charArray[i] = 81;
                    continue block28;
                }
                case 'r': {
                    charArray[i] = 82;
                    continue block28;
                }
                case 's': {
                    charArray[i] = 83;
                    continue block28;
                }
                case 't': {
                    charArray[i] = 84;
                    continue block28;
                }
                case 'u': {
                    charArray[i] = 85;
                    continue block28;
                }
                case 'v': {
                    charArray[i] = 86;
                    continue block28;
                }
                case 'w': {
                    charArray[i] = 87;
                    continue block28;
                }
                case 'x': {
                    charArray[i] = 88;
                    continue block28;
                }
                case 'y': {
                    charArray[i] = 89;
                    continue block28;
                }
                case 'z': {
                    charArray[i] = 90;
                    continue block28;
                }
                default: {
                    if (charArray[i] <= '\u007f') continue block28;
                    return s.toUpperCase();
                }
            }
        }
        return new String(charArray);
    }

    public static boolean isHex(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return true;
            }
        }
        return false;
    }

    public static String toHex(byte b) {
        StringBuilder buffer = new StringBuilder(2);
        StaticUtils.toHex(b, buffer);
        return buffer.toString();
    }

    public static void toHex(byte b, StringBuilder buffer) {
        switch (b & 0xF0) {
            case 0: {
                buffer.append('0');
                break;
            }
            case 16: {
                buffer.append('1');
                break;
            }
            case 32: {
                buffer.append('2');
                break;
            }
            case 48: {
                buffer.append('3');
                break;
            }
            case 64: {
                buffer.append('4');
                break;
            }
            case 80: {
                buffer.append('5');
                break;
            }
            case 96: {
                buffer.append('6');
                break;
            }
            case 112: {
                buffer.append('7');
                break;
            }
            case 128: {
                buffer.append('8');
                break;
            }
            case 144: {
                buffer.append('9');
                break;
            }
            case 160: {
                buffer.append('a');
                break;
            }
            case 176: {
                buffer.append('b');
                break;
            }
            case 192: {
                buffer.append('c');
                break;
            }
            case 208: {
                buffer.append('d');
                break;
            }
            case 224: {
                buffer.append('e');
                break;
            }
            case 240: {
                buffer.append('f');
            }
        }
        switch (b & 0xF) {
            case 0: {
                buffer.append('0');
                break;
            }
            case 1: {
                buffer.append('1');
                break;
            }
            case 2: {
                buffer.append('2');
                break;
            }
            case 3: {
                buffer.append('3');
                break;
            }
            case 4: {
                buffer.append('4');
                break;
            }
            case 5: {
                buffer.append('5');
                break;
            }
            case 6: {
                buffer.append('6');
                break;
            }
            case 7: {
                buffer.append('7');
                break;
            }
            case 8: {
                buffer.append('8');
                break;
            }
            case 9: {
                buffer.append('9');
                break;
            }
            case 10: {
                buffer.append('a');
                break;
            }
            case 11: {
                buffer.append('b');
                break;
            }
            case 12: {
                buffer.append('c');
                break;
            }
            case 13: {
                buffer.append('d');
                break;
            }
            case 14: {
                buffer.append('e');
                break;
            }
            case 15: {
                buffer.append('f');
            }
        }
    }

    public static String toHex(byte[] b) {
        Validator.ensureNotNull(b);
        StringBuilder buffer = new StringBuilder(2 * b.length);
        StaticUtils.toHex(b, buffer);
        return buffer.toString();
    }

    public static void toHex(byte[] b, StringBuilder buffer) {
        StaticUtils.toHex(b, null, buffer);
    }

    public static void toHex(byte[] b, String delimiter, StringBuilder buffer) {
        boolean first = true;
        for (byte bt : b) {
            if (first) {
                first = false;
            } else if (delimiter != null) {
                buffer.append(delimiter);
            }
            StaticUtils.toHex(bt, buffer);
        }
    }

    public static String toHexPlusASCII(byte[] array, int indent) {
        StringBuilder buffer = new StringBuilder();
        StaticUtils.toHexPlusASCII(array, indent, buffer);
        return buffer.toString();
    }

    public static void toHexPlusASCII(byte[] array, int indent, StringBuilder buffer) {
        int missingBytes;
        if (array == null || array.length == 0) {
            return;
        }
        for (int i = 0; i < indent; ++i) {
            buffer.append(' ');
        }
        int pos = 0;
        int startPos = 0;
        while (pos < array.length) {
            int i;
            StaticUtils.toHex(array[pos++], buffer);
            buffer.append(' ');
            if (pos % 16 != 0) continue;
            buffer.append("  ");
            for (i = startPos; i < pos; ++i) {
                if (array[i] < 32 || array[i] > 126) {
                    buffer.append(' ');
                    continue;
                }
                buffer.append((char)array[i]);
            }
            buffer.append(EOL);
            startPos = pos;
            if (pos >= array.length) continue;
            for (i = 0; i < indent; ++i) {
                buffer.append(' ');
            }
        }
        if (array.length % 16 != 0 && (missingBytes = 16 - array.length % 16) > 0) {
            int i;
            for (i = 0; i < missingBytes; ++i) {
                buffer.append("   ");
            }
            buffer.append("  ");
            for (i = startPos; i < array.length; ++i) {
                if (array[i] < 32 || array[i] > 126) {
                    buffer.append(' ');
                    continue;
                }
                buffer.append((char)array[i]);
            }
            buffer.append(EOL);
        }
    }

    public static byte[] fromHex(String hexString) throws ParseException {
        if (hexString.length() % 2 != 0) {
            throw new ParseException(UtilityMessages.ERR_FROM_HEX_ODD_NUMBER_OF_CHARACTERS.get(hexString.length()), hexString.length());
        }
        byte[] decodedBytes = new byte[hexString.length() / 2];
        int i = 0;
        int j = 0;
        while (i < decodedBytes.length) {
            switch (hexString.charAt(j)) {
                case '0': {
                    break;
                }
                case '1': {
                    decodedBytes[i] = 16;
                    break;
                }
                case '2': {
                    decodedBytes[i] = 32;
                    break;
                }
                case '3': {
                    decodedBytes[i] = 48;
                    break;
                }
                case '4': {
                    decodedBytes[i] = 64;
                    break;
                }
                case '5': {
                    decodedBytes[i] = 80;
                    break;
                }
                case '6': {
                    decodedBytes[i] = 96;
                    break;
                }
                case '7': {
                    decodedBytes[i] = 112;
                    break;
                }
                case '8': {
                    decodedBytes[i] = -128;
                    break;
                }
                case '9': {
                    decodedBytes[i] = -112;
                    break;
                }
                case 'A': 
                case 'a': {
                    decodedBytes[i] = -96;
                    break;
                }
                case 'B': 
                case 'b': {
                    decodedBytes[i] = -80;
                    break;
                }
                case 'C': 
                case 'c': {
                    decodedBytes[i] = -64;
                    break;
                }
                case 'D': 
                case 'd': {
                    decodedBytes[i] = -48;
                    break;
                }
                case 'E': 
                case 'e': {
                    decodedBytes[i] = -32;
                    break;
                }
                case 'F': 
                case 'f': {
                    decodedBytes[i] = -16;
                    break;
                }
                default: {
                    throw new ParseException(UtilityMessages.ERR_FROM_HEX_NON_HEX_CHARACTER.get(j), j);
                }
            }
            switch (hexString.charAt(j + 1)) {
                case '0': {
                    break;
                }
                case '1': {
                    int n = i;
                    decodedBytes[n] = (byte)(decodedBytes[n] | 1);
                    break;
                }
                case '2': {
                    int n = i;
                    decodedBytes[n] = (byte)(decodedBytes[n] | 2);
                    break;
                }
                case '3': {
                    int n = i;
                    decodedBytes[n] = (byte)(decodedBytes[n] | 3);
                    break;
                }
                case '4': {
                    int n = i;
                    decodedBytes[n] = (byte)(decodedBytes[n] | 4);
                    break;
                }
                case '5': {
                    int n = i;
                    decodedBytes[n] = (byte)(decodedBytes[n] | 5);
                    break;
                }
                case '6': {
                    int n = i;
                    decodedBytes[n] = (byte)(decodedBytes[n] | 6);
                    break;
                }
                case '7': {
                    int n = i;
                    decodedBytes[n] = (byte)(decodedBytes[n] | 7);
                    break;
                }
                case '8': {
                    int n = i;
                    decodedBytes[n] = (byte)(decodedBytes[n] | 8);
                    break;
                }
                case '9': {
                    int n = i;
                    decodedBytes[n] = (byte)(decodedBytes[n] | 9);
                    break;
                }
                case 'A': 
                case 'a': {
                    int n = i;
                    decodedBytes[n] = (byte)(decodedBytes[n] | 0xA);
                    break;
                }
                case 'B': 
                case 'b': {
                    int n = i;
                    decodedBytes[n] = (byte)(decodedBytes[n] | 0xB);
                    break;
                }
                case 'C': 
                case 'c': {
                    int n = i;
                    decodedBytes[n] = (byte)(decodedBytes[n] | 0xC);
                    break;
                }
                case 'D': 
                case 'd': {
                    int n = i;
                    decodedBytes[n] = (byte)(decodedBytes[n] | 0xD);
                    break;
                }
                case 'E': 
                case 'e': {
                    int n = i;
                    decodedBytes[n] = (byte)(decodedBytes[n] | 0xE);
                    break;
                }
                case 'F': 
                case 'f': {
                    int n = i;
                    decodedBytes[n] = (byte)(decodedBytes[n] | 0xF);
                    break;
                }
                default: {
                    throw new ParseException(UtilityMessages.ERR_FROM_HEX_NON_HEX_CHARACTER.get(j + 1), j + 1);
                }
            }
            ++i;
            j += 2;
        }
        return decodedBytes;
    }

    public static void hexEncode(char c, StringBuilder buffer) {
        byte[] charBytes = c <= '\u007f' ? new byte[]{(byte)(c & 0x7F)} : StaticUtils.getBytes(String.valueOf(c));
        for (byte b : charBytes) {
            buffer.append('\\');
            StaticUtils.toHex(b, buffer);
        }
    }

    public static void hexEncode(int codePoint, StringBuilder buffer) {
        byte[] charBytes;
        for (byte b : charBytes = StaticUtils.getBytes(new String(new int[]{codePoint}, 0, 1))) {
            buffer.append('\\');
            StaticUtils.toHex(b, buffer);
        }
    }

    public static void byteArrayToCode(byte[] array, StringBuilder buffer) {
        buffer.append("new byte[] {");
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buffer.append(',');
            }
            buffer.append(" (byte) 0x");
            StaticUtils.toHex(array[i], buffer);
        }
        buffer.append(" }");
    }

    public static String getStackTrace(Throwable t) {
        StringBuilder buffer = new StringBuilder();
        StaticUtils.getStackTrace(t, buffer);
        return buffer.toString();
    }

    public static void getStackTrace(Throwable t, StringBuilder buffer) {
        buffer.append(StaticUtils.getUnqualifiedClassName(t.getClass()));
        buffer.append('(');
        String message = t.getMessage();
        if (message != null) {
            buffer.append("message='");
            buffer.append(message);
            buffer.append("', ");
        }
        buffer.append("trace='");
        StaticUtils.getStackTrace(t.getStackTrace(), buffer);
        buffer.append('\'');
        Throwable cause = t.getCause();
        if (cause != null) {
            buffer.append(", cause=");
            StaticUtils.getStackTrace(cause, buffer);
        }
        String ldapSDKVersionString = ", ldapSDKVersion=4.0.14, revision=c0fb784eebf9d36a67c736d0428fb3577f2e25bb";
        if (buffer.indexOf(", ldapSDKVersion=4.0.14, revision=c0fb784eebf9d36a67c736d0428fb3577f2e25bb") < 0) {
            buffer.append(", ldapSDKVersion=4.0.14, revision=c0fb784eebf9d36a67c736d0428fb3577f2e25bb");
        }
        buffer.append(')');
    }

    public static String getStackTrace(StackTraceElement[] elements) {
        StringBuilder buffer = new StringBuilder();
        StaticUtils.getStackTrace(elements, buffer);
        return buffer.toString();
    }

    public static void getStackTrace(StackTraceElement[] elements, StringBuilder buffer) {
        StaticUtils.getStackTrace(elements, buffer, -1);
    }

    public static void getStackTrace(StackTraceElement[] elements, StringBuilder buffer, int maxPreSDKFrames) {
        boolean sdkElementFound = false;
        int numPreSDKElementsFound = 0;
        for (int i = 0; i < elements.length; ++i) {
            if (i > 0) {
                buffer.append(" / ");
            }
            if (elements[i].getClassName().startsWith("com.unboundid.")) {
                sdkElementFound = true;
            } else if (sdkElementFound) {
                if (maxPreSDKFrames >= 0 && numPreSDKElementsFound >= maxPreSDKFrames) {
                    buffer.append("...");
                    return;
                }
                ++numPreSDKElementsFound;
            }
            buffer.append(elements[i].getMethodName());
            buffer.append('(');
            buffer.append(elements[i].getFileName());
            int lineNumber = elements[i].getLineNumber();
            if (lineNumber > 0) {
                buffer.append(':');
                buffer.append(lineNumber);
            } else if (elements[i].isNativeMethod()) {
                buffer.append(":native");
            } else {
                buffer.append(":unknown");
            }
            buffer.append(')');
        }
    }

    public static String getExceptionMessage(Throwable t) {
        boolean includeCause = Boolean.getBoolean("com.unboundid.ldap.sdk.debug.includeCauseInExceptionMessages");
        boolean includeStackTrace = Boolean.getBoolean("com.unboundid.ldap.sdk.debug.includeStackTraceInExceptionMessages");
        return StaticUtils.getExceptionMessage(t, includeCause, includeStackTrace);
    }

    public static String getExceptionMessage(Throwable t, boolean includeCause, boolean includeStackTrace) {
        if (t == null) {
            return UtilityMessages.ERR_NO_EXCEPTION.get();
        }
        StringBuilder buffer = new StringBuilder();
        if (t instanceof LDAPSDKException) {
            buffer.append(((LDAPSDKException)t).getExceptionMessage());
        } else if (t instanceof LDAPSDKRuntimeException) {
            buffer.append(((LDAPSDKRuntimeException)t).getExceptionMessage());
        } else if (t instanceof NullPointerException) {
            buffer.append("NullPointerException(");
            StaticUtils.getStackTrace(t.getStackTrace(), buffer, 3);
            buffer.append(')');
        } else if (t.getMessage() == null || t.getMessage().isEmpty() || t.getMessage().equalsIgnoreCase("null")) {
            StaticUtils.getStackTrace(t, buffer);
        } else {
            Throwable cause;
            buffer.append(t.getClass().getSimpleName());
            buffer.append('(');
            buffer.append(t.getMessage());
            buffer.append(')');
            if (includeStackTrace) {
                buffer.append(" trace=");
                StaticUtils.getStackTrace(t, buffer);
            } else if (includeCause && (cause = t.getCause()) != null) {
                buffer.append(" caused by ");
                buffer.append(StaticUtils.getExceptionMessage(cause));
            }
        }
        String ldapSDKVersionString = ", ldapSDKVersion=4.0.14, revision=c0fb784eebf9d36a67c736d0428fb3577f2e25bb";
        if (buffer.indexOf(", ldapSDKVersion=4.0.14, revision=c0fb784eebf9d36a67c736d0428fb3577f2e25bb") < 0) {
            buffer.append(", ldapSDKVersion=4.0.14, revision=c0fb784eebf9d36a67c736d0428fb3577f2e25bb");
        }
        return buffer.toString();
    }

    public static String getUnqualifiedClassName(Class<?> c) {
        String className = c.getName();
        int lastPeriodPos = className.lastIndexOf(46);
        if (lastPeriodPos > 0) {
            return className.substring(lastPeriodPos + 1);
        }
        return className;
    }

    public static TimeZone getUTCTimeZone() {
        return UTC_TIME_ZONE;
    }

    public static String encodeGeneralizedTime(long timestamp) {
        return StaticUtils.encodeGeneralizedTime(new Date(timestamp));
    }

    public static String encodeGeneralizedTime(Date d) {
        SimpleDateFormat dateFormat = DATE_FORMATTERS.get();
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("yyyyMMddHHmmss.SSS'Z'");
            dateFormat.setTimeZone(UTC_TIME_ZONE);
            DATE_FORMATTERS.set(dateFormat);
        }
        return dateFormat.format(d);
    }

    public static Date decodeGeneralizedTime(String t) throws ParseException {
        String formatStr;
        String trimmedTimestamp;
        String subSecFormatStr;
        int tzPos;
        TimeZone tz;
        Validator.ensureNotNull(t);
        if (t.endsWith("Z")) {
            tz = TimeZone.getTimeZone("UTC");
            tzPos = t.length() - 1;
        } else {
            tzPos = t.lastIndexOf(45);
            if (tzPos < 0 && (tzPos = t.lastIndexOf(43)) < 0) {
                throw new ParseException(UtilityMessages.ERR_GENTIME_DECODE_CANNOT_PARSE_TZ.get(t), 0);
            }
            tz = TimeZone.getTimeZone("GMT" + t.substring(tzPos));
            if (tz.getRawOffset() == 0 && !t.endsWith("+0000") && !t.endsWith("-0000")) {
                throw new ParseException(UtilityMessages.ERR_GENTIME_DECODE_CANNOT_PARSE_TZ.get(t), tzPos);
            }
        }
        int periodPos = t.lastIndexOf(46, tzPos);
        if (periodPos > 0) {
            int subSecondLength = tzPos - periodPos - 1;
            switch (subSecondLength) {
                case 0: {
                    subSecFormatStr = "";
                    trimmedTimestamp = t.substring(0, periodPos);
                    break;
                }
                case 1: {
                    subSecFormatStr = ".SSS";
                    trimmedTimestamp = t.substring(0, periodPos + 2) + "00";
                    break;
                }
                case 2: {
                    subSecFormatStr = ".SSS";
                    trimmedTimestamp = t.substring(0, periodPos + 3) + '0';
                    break;
                }
                default: {
                    subSecFormatStr = ".SSS";
                    trimmedTimestamp = t.substring(0, periodPos + 4);
                    break;
                }
            }
        } else {
            subSecFormatStr = "";
            periodPos = tzPos;
            trimmedTimestamp = t.substring(0, tzPos);
        }
        switch (periodPos) {
            case 10: {
                formatStr = "yyyyMMddHH" + subSecFormatStr;
                break;
            }
            case 12: {
                formatStr = "yyyyMMddHHmm" + subSecFormatStr;
                break;
            }
            case 14: {
                formatStr = "yyyyMMddHHmmss" + subSecFormatStr;
                break;
            }
            default: {
                throw new ParseException(UtilityMessages.ERR_GENTIME_CANNOT_PARSE_INVALID_LENGTH.get(t), periodPos);
            }
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(formatStr);
        dateFormat.setTimeZone(tz);
        dateFormat.setLenient(false);
        return dateFormat.parse(trimmedTimestamp);
    }

    public static String trimLeading(String s) {
        int nonSpacePos;
        Validator.ensureNotNull(s);
        int length = s.length();
        for (nonSpacePos = 0; nonSpacePos < length && s.charAt(nonSpacePos) == ' '; ++nonSpacePos) {
        }
        if (nonSpacePos == 0) {
            return s;
        }
        if (nonSpacePos >= length) {
            return "";
        }
        return s.substring(nonSpacePos, length);
    }

    public static String trimTrailing(String s) {
        int lastPos;
        int nonSpacePos;
        Validator.ensureNotNull(s);
        for (nonSpacePos = lastPos = s.length() - 1; nonSpacePos >= 0 && s.charAt(nonSpacePos) == ' '; --nonSpacePos) {
        }
        if (nonSpacePos < 0) {
            return "";
        }
        if (nonSpacePos == lastPos) {
            return s;
        }
        return s.substring(0, nonSpacePos + 1);
    }

    public static List<String> wrapLine(String line, int maxWidth) {
        return StaticUtils.wrapLine(line, maxWidth, maxWidth);
    }

    public static List<String> wrapLine(String line, int maxFirstLineWidth, int maxSubsequentLineWidth) {
        ArrayList<String> lineList;
        block9: {
            String s;
            int breakPos;
            if (maxFirstLineWidth > 0) {
                Validator.ensureTrue(maxSubsequentLineWidth > 0);
            }
            if ((breakPos = line.indexOf(10)) >= 0) {
                ArrayList<String> lineList2 = new ArrayList<String>(10);
                StringTokenizer tokenizer = new StringTokenizer(line, "\r\n");
                while (tokenizer.hasMoreTokens()) {
                    lineList2.addAll(StaticUtils.wrapLine(tokenizer.nextToken(), maxFirstLineWidth, maxSubsequentLineWidth));
                }
                return lineList2;
            }
            int length = line.length();
            if (maxFirstLineWidth <= 0 || length < maxFirstLineWidth) {
                return Collections.singletonList(line);
            }
            int wrapPos = maxFirstLineWidth;
            int lastWrapPos = 0;
            lineList = new ArrayList<String>(5);
            do {
                int spacePos;
                if ((spacePos = line.lastIndexOf(32, wrapPos)) > lastWrapPos) {
                    s = StaticUtils.trimTrailing(line.substring(lastWrapPos, spacePos));
                    if (!s.isEmpty()) {
                        lineList.add(s);
                    }
                    wrapPos = spacePos;
                } else {
                    lineList.add(line.substring(lastWrapPos, wrapPos));
                }
                while (wrapPos < length && line.charAt(wrapPos) == ' ') {
                    ++wrapPos;
                }
                lastWrapPos = wrapPos;
            } while ((wrapPos += maxSubsequentLineWidth) < length);
            if (lastWrapPos >= length || (s = line.substring(lastWrapPos)).isEmpty()) break block9;
            lineList.add(s);
        }
        return lineList;
    }

    public static String cleanExampleCommandLineArgument(String s) {
        return ExampleCommandLineArgument.getCleanArgument(s).getLocalForm();
    }

    public static String concatenateStrings(String ... a) {
        return StaticUtils.concatenateStrings(null, null, "  ", null, null, a);
    }

    public static String concatenateStrings(List<String> l) {
        return StaticUtils.concatenateStrings(null, null, "  ", null, null, l);
    }

    public static String concatenateStrings(String beforeList, String beforeElement, String betweenElements, String afterElement, String afterList, String ... a) {
        return StaticUtils.concatenateStrings(beforeList, beforeElement, betweenElements, afterElement, afterList, Arrays.asList(a));
    }

    public static String concatenateStrings(String beforeList, String beforeElement, String betweenElements, String afterElement, String afterList, List<String> l) {
        Validator.ensureNotNull(l);
        StringBuilder buffer = new StringBuilder();
        if (beforeList != null) {
            buffer.append(beforeList);
        }
        Iterator<String> iterator = l.iterator();
        while (iterator.hasNext()) {
            if (beforeElement != null) {
                buffer.append(beforeElement);
            }
            buffer.append(iterator.next());
            if (afterElement != null) {
                buffer.append(afterElement);
            }
            if (betweenElements == null || !iterator.hasNext()) continue;
            buffer.append(betweenElements);
        }
        if (afterList != null) {
            buffer.append(afterList);
        }
        return buffer.toString();
    }

    public static String secondsToHumanReadableDuration(long s) {
        return StaticUtils.millisToHumanReadableDuration(s * 1000L);
    }

    public static String millisToHumanReadableDuration(long m) {
        long numMinutes;
        long numHours;
        StringBuilder buffer = new StringBuilder();
        long numMillis = m;
        long numDays = numMillis / 86400000L;
        if (numDays > 0L) {
            numMillis -= numDays * 86400000L;
            if (numDays == 1L) {
                buffer.append(UtilityMessages.INFO_NUM_DAYS_SINGULAR.get(numDays));
            } else {
                buffer.append(UtilityMessages.INFO_NUM_DAYS_PLURAL.get(numDays));
            }
        }
        if ((numHours = numMillis / 3600000L) > 0L) {
            numMillis -= numHours * 3600000L;
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            if (numHours == 1L) {
                buffer.append(UtilityMessages.INFO_NUM_HOURS_SINGULAR.get(numHours));
            } else {
                buffer.append(UtilityMessages.INFO_NUM_HOURS_PLURAL.get(numHours));
            }
        }
        if ((numMinutes = numMillis / 60000L) > 0L) {
            numMillis -= numMinutes * 60000L;
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            if (numMinutes == 1L) {
                buffer.append(UtilityMessages.INFO_NUM_MINUTES_SINGULAR.get(numMinutes));
            } else {
                buffer.append(UtilityMessages.INFO_NUM_MINUTES_PLURAL.get(numMinutes));
            }
        }
        if (numMillis == 1000L) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(UtilityMessages.INFO_NUM_SECONDS_SINGULAR.get(1));
        } else if (numMillis > 0L || buffer.length() == 0) {
            long numSeconds;
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            if ((numMillis -= (numSeconds = numMillis / 1000L) * 1000L) % 1000L != 0L) {
                double numSecondsDouble = (double)numSeconds + (double)numMillis / 1000.0;
                DecimalFormat decimalFormat = new DecimalFormat("0.000");
                buffer.append(UtilityMessages.INFO_NUM_SECONDS_WITH_DECIMAL.get(decimalFormat.format(numSecondsDouble)));
            } else {
                buffer.append(UtilityMessages.INFO_NUM_SECONDS_PLURAL.get(numSeconds));
            }
        }
        return buffer.toString();
    }

    public static long nanosToMillis(long nanos) {
        return Math.max(0L, Math.round((double)nanos / 1000000.0));
    }

    public static long millisToNanos(long millis) {
        return Math.max(0L, millis * 1000000L);
    }

    public static boolean isNumericOID(String s) {
        boolean digitRequired = true;
        boolean periodFound = false;
        block4: for (char c : s.toCharArray()) {
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    digitRequired = false;
                    continue block4;
                }
                case '.': {
                    if (digitRequired) {
                        return false;
                    }
                    digitRequired = true;
                    periodFound = true;
                    continue block4;
                }
                default: {
                    return false;
                }
            }
        }
        return periodFound && !digitRequired;
    }

    public static String capitalize(String s) {
        return StaticUtils.capitalize(s, false);
    }

    public static String capitalize(String s, boolean allWords) {
        if (s == null) {
            return null;
        }
        switch (s.length()) {
            case 0: {
                return s;
            }
            case 1: {
                return s.toUpperCase();
            }
        }
        boolean capitalize = true;
        char[] chars = s.toCharArray();
        StringBuilder buffer = new StringBuilder(chars.length);
        for (char c : chars) {
            if (Character.isWhitespace(c) || c >= '!' && c <= '.' || c >= ':' && c <= '@' || c >= '[' && c <= '`' || c >= '{' && c <= '~') {
                buffer.append(c);
                capitalize |= allWords;
                continue;
            }
            if (capitalize) {
                buffer.append(Character.toUpperCase(c));
                capitalize = false;
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static byte[] encodeUUID(UUID uuid) {
        byte[] b = new byte[16];
        long mostSignificantBits = uuid.getMostSignificantBits();
        b[0] = (byte)(mostSignificantBits >> 56 & 0xFFL);
        b[1] = (byte)(mostSignificantBits >> 48 & 0xFFL);
        b[2] = (byte)(mostSignificantBits >> 40 & 0xFFL);
        b[3] = (byte)(mostSignificantBits >> 32 & 0xFFL);
        b[4] = (byte)(mostSignificantBits >> 24 & 0xFFL);
        b[5] = (byte)(mostSignificantBits >> 16 & 0xFFL);
        b[6] = (byte)(mostSignificantBits >> 8 & 0xFFL);
        b[7] = (byte)(mostSignificantBits & 0xFFL);
        long leastSignificantBits = uuid.getLeastSignificantBits();
        b[8] = (byte)(leastSignificantBits >> 56 & 0xFFL);
        b[9] = (byte)(leastSignificantBits >> 48 & 0xFFL);
        b[10] = (byte)(leastSignificantBits >> 40 & 0xFFL);
        b[11] = (byte)(leastSignificantBits >> 32 & 0xFFL);
        b[12] = (byte)(leastSignificantBits >> 24 & 0xFFL);
        b[13] = (byte)(leastSignificantBits >> 16 & 0xFFL);
        b[14] = (byte)(leastSignificantBits >> 8 & 0xFFL);
        b[15] = (byte)(leastSignificantBits & 0xFFL);
        return b;
    }

    public static UUID decodeUUID(byte[] b) throws ParseException {
        if (b.length != 16) {
            throw new ParseException(UtilityMessages.ERR_DECODE_UUID_INVALID_LENGTH.get(StaticUtils.toHex(b)), 0);
        }
        long mostSignificantBits = 0L;
        for (int i = 0; i < 8; ++i) {
            mostSignificantBits = mostSignificantBits << 8 | (long)(b[i] & 0xFF);
        }
        long leastSignificantBits = 0L;
        for (int i = 8; i < 16; ++i) {
            leastSignificantBits = leastSignificantBits << 8 | (long)(b[i] & 0xFF);
        }
        return new UUID(mostSignificantBits, leastSignificantBits);
    }

    public static boolean isWindows() {
        String osName = StaticUtils.toLowerCase(StaticUtils.getSystemProperty("os.name"));
        return osName != null && osName.contains("windows");
    }

    public static List<String> toArgumentList(String s) throws ParseException {
        if (s == null || s.isEmpty()) {
            return Collections.emptyList();
        }
        int quoteStartPos = -1;
        boolean inEscape = false;
        ArrayList<String> argList = new ArrayList<String>(20);
        StringBuilder currentArg = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (inEscape) {
                currentArg.append(c);
                inEscape = false;
                continue;
            }
            if (c == '\\') {
                inEscape = true;
                continue;
            }
            if (c == '\"') {
                if (quoteStartPos >= 0) {
                    quoteStartPos = -1;
                    continue;
                }
                quoteStartPos = i;
                continue;
            }
            if (c == ' ') {
                if (quoteStartPos >= 0) {
                    currentArg.append(c);
                    continue;
                }
                if (currentArg.length() <= 0) continue;
                argList.add(currentArg.toString());
                currentArg.setLength(0);
                continue;
            }
            currentArg.append(c);
        }
        if (s.endsWith("\\") && !s.endsWith("\\\\")) {
            throw new ParseException(UtilityMessages.ERR_ARG_STRING_DANGLING_BACKSLASH.get(), s.length() - 1);
        }
        if (quoteStartPos >= 0) {
            throw new ParseException(UtilityMessages.ERR_ARG_STRING_UNMATCHED_QUOTE.get(quoteStartPos), quoteStartPos);
        }
        if (currentArg.length() > 0) {
            argList.add(currentArg.toString());
        }
        return Collections.unmodifiableList(argList);
    }

    public static <T> T[] toArray(Collection<T> collection, Class<T> type) {
        if (collection == null) {
            return null;
        }
        Object[] array = (Object[])Array.newInstance(type, collection.size());
        return collection.toArray(array);
    }

    public static <T> List<T> toList(T[] array) {
        if (array == null) {
            return null;
        }
        ArrayList<T> l = new ArrayList<T>(array.length);
        l.addAll(Arrays.asList(array));
        return l;
    }

    public static <T> List<T> toNonNullList(T[] array) {
        if (array == null) {
            return new ArrayList(0);
        }
        ArrayList<T> l = new ArrayList<T>(array.length);
        l.addAll(Arrays.asList(array));
        return l;
    }

    public static boolean bothNullOrEqual(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static boolean bothNullOrEqualIgnoreCase(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        return s1.equalsIgnoreCase(s2);
    }

    public static boolean stringsEqualIgnoreCaseOrderIndependent(String[] a1, String[] a2) {
        if (a1 == null) {
            return a2 == null;
        }
        if (a2 == null) {
            return false;
        }
        if (a1.length != a2.length) {
            return false;
        }
        if (a1.length == 1) {
            return a1[0].equalsIgnoreCase(a2[0]);
        }
        HashSet<String> s1 = new HashSet<String>(StaticUtils.computeMapCapacity(a1.length));
        for (String s : a1) {
            s1.add(StaticUtils.toLowerCase(s));
        }
        HashSet<String> s2 = new HashSet<String>(StaticUtils.computeMapCapacity(a2.length));
        for (String s : a2) {
            s2.add(StaticUtils.toLowerCase(s));
        }
        return s1.equals(s2);
    }

    public static <T> boolean arraysEqualOrderIndependent(T[] a1, T[] a2) {
        if (a1 == null) {
            return a2 == null;
        }
        if (a2 == null) {
            return false;
        }
        if (a1.length != a2.length) {
            return false;
        }
        if (a1.length == 1) {
            return a1[0].equals(a2[0]);
        }
        HashSet<T> s1 = new HashSet<T>(Arrays.asList(a1));
        HashSet<T> s2 = new HashSet<T>(Arrays.asList(a2));
        return s1.equals(s2);
    }

    public static int numBytesInUTF8CharacterWithFirstByte(byte b) {
        if ((b & 0x7F) == b) {
            return 1;
        }
        if ((b & 0xE0) == 192) {
            return 2;
        }
        if ((b & 0xF0) == 224) {
            return 3;
        }
        if ((b & 0xF8) == 240) {
            return 4;
        }
        return -1;
    }

    public static boolean isSensitiveToCodeAttribute(String name) {
        String lowerBaseName = Attribute.getBaseName(name).toLowerCase();
        return TO_CODE_SENSITIVE_ATTRIBUTE_NAMES.contains(lowerBaseName);
    }

    public static Set<String> getSensitiveToCodeAttributeBaseNames() {
        return TO_CODE_SENSITIVE_ATTRIBUTE_NAMES;
    }

    public static void setSensitiveToCodeAttributes(String ... names) {
        StaticUtils.setSensitiveToCodeAttributes(StaticUtils.toList(names));
    }

    public static void setSensitiveToCodeAttributes(Collection<String> names) {
        if (names == null || names.isEmpty()) {
            TO_CODE_SENSITIVE_ATTRIBUTE_NAMES = Collections.emptySet();
        } else {
            LinkedHashSet<String> nameSet = new LinkedHashSet<String>(names.size());
            for (String s : names) {
                nameSet.add(Attribute.getBaseName(s).toLowerCase());
            }
            TO_CODE_SENSITIVE_ATTRIBUTE_NAMES = Collections.unmodifiableSet(nameSet);
        }
    }

    public static IOException createIOExceptionWithCause(String message, Throwable cause) {
        if (cause == null) {
            return new IOException(message);
        }
        if (message == null) {
            return new IOException(cause);
        }
        return new IOException(message, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> stringToLines(String s) {
        ArrayList<String> l = new ArrayList<String>(10);
        if (s == null) {
            return l;
        }
        BufferedReader reader = new BufferedReader(new StringReader(s));
        try {
            while (true) {
                String line;
                if ((line = reader.readLine()) == null) {
                    ArrayList<String> arrayList = l;
                    return arrayList;
                }
                l.add(line);
                continue;
                break;
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            l.clear();
            l.add(s);
            ArrayList<String> arrayList = l;
            return arrayList;
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
    }

    public static String linesToString(CharSequence ... lines) {
        if (lines == null) {
            return "";
        }
        return StaticUtils.linesToString(Arrays.asList(lines));
    }

    public static String linesToString(List<? extends CharSequence> lines) {
        if (lines == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (CharSequence charSequence : lines) {
            buffer.append(charSequence);
            buffer.append(EOL);
        }
        return buffer.toString();
    }

    public static File constructPath(File baseDirectory, String ... pathElements) {
        Validator.ensureNotNull(baseDirectory);
        File f = baseDirectory;
        if (pathElements != null) {
            for (String pathElement : pathElements) {
                f = new File(f, pathElement);
            }
        }
        return f;
    }

    public static byte[] byteArray(int ... bytes) {
        if (bytes == null || bytes.length == 0) {
            return NO_BYTES;
        }
        byte[] byteArray = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            byteArray[i] = (byte)(bytes[i] & 0xFF);
        }
        return byteArray;
    }

    public static boolean isWithinUnitTest() {
        return IS_WITHIN_UNIT_TESTS;
    }

    public static void throwErrorOrRuntimeException(Throwable throwable) throws Error, RuntimeException {
        Validator.ensureNotNull(throwable);
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new RuntimeException(throwable);
    }

    public static void rethrowIfErrorOrRuntimeException(Throwable throwable) throws Error, RuntimeException {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
    }

    public static void rethrowIfError(Throwable throwable) throws Error {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
    }

    public static int computeMapCapacity(int expectedItemCount) {
        switch (expectedItemCount) {
            case 0: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 6;
            }
            case 5: {
                return 7;
            }
            case 6: {
                return 9;
            }
            case 7: {
                return 10;
            }
            case 8: {
                return 11;
            }
            case 9: {
                return 13;
            }
            case 10: {
                return 14;
            }
            case 11: {
                return 15;
            }
            case 12: {
                return 17;
            }
            case 13: {
                return 18;
            }
            case 14: {
                return 19;
            }
            case 15: {
                return 21;
            }
            case 16: {
                return 22;
            }
            case 17: {
                return 23;
            }
            case 18: {
                return 25;
            }
            case 19: {
                return 26;
            }
            case 20: {
                return 27;
            }
            case 30: {
                return 41;
            }
            case 40: {
                return 54;
            }
            case 50: {
                return 67;
            }
            case 60: {
                return 81;
            }
            case 70: {
                return 94;
            }
            case 80: {
                return 107;
            }
            case 90: {
                return 121;
            }
            case 100: {
                return 134;
            }
            case 110: {
                return 147;
            }
            case 120: {
                return 161;
            }
            case 130: {
                return 174;
            }
            case 140: {
                return 187;
            }
            case 150: {
                return 201;
            }
            case 160: {
                return 214;
            }
            case 170: {
                return 227;
            }
            case 180: {
                return 241;
            }
            case 190: {
                return 254;
            }
            case 200: {
                return 267;
            }
        }
        Validator.ensureTrue(expectedItemCount >= 0, "StaticUtils.computeMapOrSetCapacity.expectedItemCount must be greater than or equal to zero.");
        if (expectedItemCount > 0x1FFFFFFF) {
            int computedCapacity = (int)((double)expectedItemCount / 0.75) + 1;
            if (computedCapacity <= expectedItemCount) {
                return expectedItemCount;
            }
            return computedCapacity;
        }
        return expectedItemCount * 4 / 3 + 1;
    }

    @SafeVarargs
    public static <T> Set<T> setOf(T ... items) {
        return Collections.unmodifiableSet(new LinkedHashSet<T>(Arrays.asList(items)));
    }

    @SafeVarargs
    public static <T> HashSet<T> hashSetOf(T ... items) {
        return new HashSet<T>(Arrays.asList(items));
    }

    @SafeVarargs
    public static <T> LinkedHashSet<T> linkedHashSetOf(T ... items) {
        return new LinkedHashSet<T>(Arrays.asList(items));
    }

    @SafeVarargs
    public static <T> TreeSet<T> treeSetOf(T ... items) {
        return new TreeSet<T>(Arrays.asList(items));
    }

    public static <K, V> Map<K, V> mapOf(K key, V value) {
        return Collections.singletonMap(key, value);
    }

    public static <K, V> Map<K, V> mapOf(K key1, V value1, K key2, V value2) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(StaticUtils.computeMapCapacity(2));
        map.put(key1, value1);
        map.put(key2, value2);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> mapOf(K key1, V value1, K key2, V value2, K key3, V value3) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(StaticUtils.computeMapCapacity(3));
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> mapOf(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(StaticUtils.computeMapCapacity(4));
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        map.put(key4, value4);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> mapOf(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4, K key5, V value5) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(StaticUtils.computeMapCapacity(5));
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        map.put(key4, value4);
        map.put(key5, value5);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> mapOf(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4, K key5, V value5, K key6, V value6) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(StaticUtils.computeMapCapacity(6));
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        map.put(key4, value4);
        map.put(key5, value5);
        map.put(key6, value6);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> mapOf(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4, K key5, V value5, K key6, V value6, K key7, V value7) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(StaticUtils.computeMapCapacity(7));
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        map.put(key4, value4);
        map.put(key5, value5);
        map.put(key6, value6);
        map.put(key7, value7);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> mapOf(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4, K key5, V value5, K key6, V value6, K key7, V value7, K key8, V value8) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(StaticUtils.computeMapCapacity(8));
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        map.put(key4, value4);
        map.put(key5, value5);
        map.put(key6, value6);
        map.put(key7, value7);
        map.put(key8, value8);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> mapOf(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4, K key5, V value5, K key6, V value6, K key7, V value7, K key8, V value8, K key9, V value9) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(StaticUtils.computeMapCapacity(9));
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        map.put(key4, value4);
        map.put(key5, value5);
        map.put(key6, value6);
        map.put(key7, value7);
        map.put(key8, value8);
        map.put(key9, value9);
        return Collections.unmodifiableMap(map);
    }

    public static <K, V> Map<K, V> mapOf(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4, K key5, V value5, K key6, V value6, K key7, V value7, K key8, V value8, K key9, V value9, K key10, V value10) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(StaticUtils.computeMapCapacity(10));
        map.put(key1, value1);
        map.put(key2, value2);
        map.put(key3, value3);
        map.put(key4, value4);
        map.put(key5, value5);
        map.put(key6, value6);
        map.put(key7, value7);
        map.put(key8, value8);
        map.put(key9, value9);
        map.put(key10, value10);
        return Collections.unmodifiableMap(map);
    }

    @SafeVarargs
    public static <T> Map<T, T> mapOf(T ... items) {
        if (items == null || items.length == 0) {
            return Collections.emptyMap();
        }
        Validator.ensureTrue(items.length % 2 == 0, "StaticUtils.mapOf.items must have an even number of elements");
        int numEntries = items.length / 2;
        LinkedHashMap<T, T> map = new LinkedHashMap<T, T>(StaticUtils.computeMapCapacity(numEntries));
        int i = 0;
        while (i < items.length) {
            map.put(items[i++], items[i++]);
        }
        return Collections.unmodifiableMap(map);
    }

    @SafeVarargs
    public static <K, V> Map<K, V> mapOfObjectPairs(ObjectPair<K, V> ... items) {
        if (items == null || items.length == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>(StaticUtils.computeMapCapacity(items.length));
        for (ObjectPair<K, V> item : items) {
            map.put(item.getFirst(), item.getSecond());
        }
        return Collections.unmodifiableMap(map);
    }

    public static Properties getSystemProperties(String ... propertyNames) {
        try {
            Properties properties = System.getProperties();
            String forceThrowPropertyName = StaticUtils.class.getName() + ".forceGetSystemPropertiesToThrow";
            String forceThrowPropertyValue = properties.getProperty(forceThrowPropertyName);
            if (forceThrowPropertyValue != null) {
                throw new SecurityException(forceThrowPropertyName + '=' + forceThrowPropertyValue);
            }
            return System.getProperties();
        }
        catch (SecurityException e) {
            Debug.debugException(e);
            Properties properties = new Properties();
            if (propertyNames != null) {
                for (String propertyName : propertyNames) {
                    String propertyValue = System.getProperty(propertyName);
                    if (propertyValue == null) continue;
                    properties.put(propertyName, propertyValue);
                }
            }
            return properties;
        }
    }

    public static String getSystemProperty(String name) {
        try {
            return System.getProperty(name);
        }
        catch (Throwable t) {
            Debug.debugException(t);
            return null;
        }
    }

    public static String getSystemProperty(String name, String defaultValue) {
        try {
            return System.getProperty(name, defaultValue);
        }
        catch (Throwable t) {
            Debug.debugException(t);
            return defaultValue;
        }
    }

    public static String setSystemProperty(String name, String value) {
        try {
            if (value == null) {
                return System.clearProperty(name);
            }
            return System.setProperty(name, value);
        }
        catch (Throwable t) {
            Debug.debugException(t);
            return null;
        }
    }

    public static String clearSystemProperty(String name) {
        try {
            return System.clearProperty(name);
        }
        catch (Throwable t) {
            Debug.debugException(t);
            return null;
        }
    }

    public static Map<String, String> getEnvironmentVariables() {
        try {
            return System.getenv();
        }
        catch (Throwable t) {
            Debug.debugException(t);
            return Collections.emptyMap();
        }
    }

    public static String getEnvironmentVariable(String name) {
        try {
            return System.getenv(name);
        }
        catch (Throwable t) {
            Debug.debugException(t);
            return null;
        }
    }

    public static void setLoggerLevel(Logger logger, Level logLevel) {
        try {
            logger.setLevel(logLevel);
        }
        catch (Throwable t) {
            Debug.debugException(t);
        }
    }

    public static void setLogHandlerLevel(Handler logHandler, Level logLevel) {
        try {
            logHandler.setLevel(logLevel);
        }
        catch (Throwable t) {
            Debug.debugException(t);
        }
    }

    public static Set<InetAddress> getAllLocalAddresses(NameResolver nameResolver) {
        NameResolver resolver = nameResolver == null ? LDAPConnectionOptions.DEFAULT_NAME_RESOLVER : nameResolver;
        LinkedHashSet<InetAddress> localAddresses = new LinkedHashSet<InetAddress>(StaticUtils.computeMapCapacity(10));
        try {
            localAddresses.add(resolver.getLocalHost());
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> interfaceAddresses = networkInterface.getInetAddresses();
                while (interfaceAddresses.hasMoreElements()) {
                    localAddresses.add(interfaceAddresses.nextElement());
                }
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        try {
            localAddresses.add(resolver.getLoopbackAddress());
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        return Collections.unmodifiableSet(localAddresses);
    }

    public static String getCanonicalHostNameIfAvailable(NameResolver nameResolver, InetAddress address) {
        NameResolver resolver = nameResolver == null ? LDAPConnectionOptions.DEFAULT_NAME_RESOLVER : nameResolver;
        String hostAddress = address.getHostAddress();
        String trimmedHostAddress = StaticUtils.trimInterfaceNameFromHostAddress(hostAddress);
        String canonicalHostName = resolver.getCanonicalHostName(address);
        if (canonicalHostName == null || canonicalHostName.equalsIgnoreCase(hostAddress) || canonicalHostName.equalsIgnoreCase(trimmedHostAddress)) {
            return null;
        }
        return canonicalHostName;
    }

    public static Set<String> getAvailableCanonicalHostNames(NameResolver nameResolver, Collection<InetAddress> addresses) {
        NameResolver resolver = nameResolver == null ? LDAPConnectionOptions.DEFAULT_NAME_RESOLVER : nameResolver;
        LinkedHashSet<String> canonicalHostNames = new LinkedHashSet<String>(StaticUtils.computeMapCapacity(addresses.size()));
        for (InetAddress address : addresses) {
            String canonicalHostName = StaticUtils.getCanonicalHostNameIfAvailable(resolver, address);
            if (canonicalHostName == null) continue;
            canonicalHostNames.add(canonicalHostName);
        }
        return Collections.unmodifiableSet(canonicalHostNames);
    }

    public static String trimInterfaceNameFromHostAddress(String hostAddress) {
        int percentPos = hostAddress.indexOf(37);
        if (percentPos > 0) {
            return hostAddress.substring(0, percentPos);
        }
        return hostAddress;
    }

    public static String getEnvironmentVariable(String name, String defaultValue) {
        String value = StaticUtils.getEnvironmentVariable(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    static {
        int terminalWidth = 80;
        String columnsEnvVar = StaticUtils.getEnvironmentVariable("COLUMNS");
        if (columnsEnvVar != null) {
            try {
                terminalWidth = Integer.parseInt(columnsEnvVar);
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        TERMINAL_WIDTH_COLUMNS = terminalWidth;
        DATE_FORMATTERS = new ThreadLocal();
        UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
        TO_CODE_SENSITIVE_ATTRIBUTE_NAMES = StaticUtils.setOf("userpassword", "2.5.4.35", "authpassword", "1.3.6.1.4.1.4203.1.3.4");
    }
}

