/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ueditor.util;

import com.baidu.ueditor.util.QStringUtil;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Properties;

public class QPropertiesUtil {
    public static final Properties config;

    public static String getJarPath() {
        String res = null;
        try {
            res = URLDecoder.decode(QPropertiesUtil.class.getProtectionDomain().getCodeSource().getLocation().getFile(), "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public static Properties readProperties(String path) {
        Properties p = new Properties();
        try {
            p.load(QPropertiesUtil.class.getResourceAsStream(path));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return p;
    }

    public static String get(String key) {
        return QPropertiesUtil.getProperty(config, key);
    }

    public static String getProperty(Properties properties, String key) {
        if (properties != null && QStringUtil.notEmpty(key)) {
            return properties.getProperty(key);
        }
        return null;
    }

    public static boolean getBoolean(String key) {
        return QPropertiesUtil.getPropertyToBoolean(config, key);
    }

    public static boolean getPropertyToBoolean(Properties properties, String key) {
        if (properties != null && QStringUtil.notEmpty(key)) {
            return Boolean.parseBoolean(properties.getProperty(key));
        }
        return false;
    }

    static {
        Properties temp = QPropertiesUtil.readProperties("/config/qiniu.properties");
        try {
            if (temp.getProperty("ueditor.upload_to", null) == null) {
                temp = QPropertiesUtil.readProperties("/config/qiniu.default.properties");
            }
        }
        catch (Exception e) {
            temp = QPropertiesUtil.readProperties("/config/qiniu.default.properties");
        }
        config = temp;
    }
}

