/*
 * Decompiled with CFR 0.152.
 */
package com.yunpian.sdk.api;

import com.yunpian.sdk.YunpianClient;
import com.yunpian.sdk.api.CallApi;
import com.yunpian.sdk.api.FlowApi;
import com.yunpian.sdk.api.ShortUrlApi;
import com.yunpian.sdk.api.SignApi;
import com.yunpian.sdk.api.SmsApi;
import com.yunpian.sdk.api.TplApi;
import com.yunpian.sdk.api.UserApi;
import com.yunpian.sdk.api.VoiceApi;
import com.yunpian.sdk.api.YunpianApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiFactory {
    static Logger LOG = LoggerFactory.getLogger(ApiFactory.class);
    private YunpianClient clnt;

    public ApiFactory(YunpianClient clnt) {
        this.clnt = clnt;
    }

    public <T extends YunpianApi> T api(String name) {
        YunpianApi t = null;
        switch (name) {
            case "call": {
                t = new CallApi();
                break;
            }
            case "flow": {
                t = new FlowApi();
                break;
            }
            case "sign": {
                t = new SignApi();
                break;
            }
            case "sms": {
                t = new SmsApi();
                break;
            }
            case "tpl": {
                t = new TplApi();
                break;
            }
            case "user": {
                t = new UserApi();
                break;
            }
            case "voice": {
                t = new VoiceApi();
                break;
            }
            case "short_url": {
                t = new ShortUrlApi();
            }
        }
        if (t != null) {
            ((YunpianApi)t).init(this.clnt);
        }
        return (T)t;
    }
}

